# Hospital Management System v3.0 - Demo Login Credentials

## All User Roles with Complete Access Details

---

## 🔐 System Access

### Login Page: `index.php?action=login`

---

## 👑 Super Administrator

**Access:** System-wide control over all hospitals

| Field | Value |
|-------|-------|
| **Login URL** | `?action=super_login` |
| **Username** | `superadmin` |
| **Password** | `superadmin123` |
| **Full Name** | Super Administrator |
| **Email** | superadmin@system.com |

**Capabilities:**
- ✅ Manage all hospitals
- ✅ Approve/reject hospital registrations
- ✅ Create hospital admin accounts
- ✅ View all data across all tenants
- ✅ System-wide statistics and reports

---

## 🏥 Hospital Administrator

**Access:** Full control over single hospital

| Field | Value |
|-------|-------|
| **Login URL** | `?action=login` |
| **Username** | `admin` |
| **Password** | `admin123` |
| **Full Name** | Hospital Administrator |
| **Employee ID** | EMP001 |
| **Email** | admin@citygeneralhospital.com |
| **Department** | Administration |

**Capabilities:**
- ✅ Manage all users for this hospital
- ✅ Configure hospital settings
- ✅ Set patient card fees
- ✅ Access all modules
- ✅ View hospital reports
- ✅ Manage billing and payments

---

## 👨‍⚕️ Doctor

**Access:** Patient consultations and prescriptions

| Field | Value |
|-------|-------|
| **Username** | `doctor1` |
| **Password** | `doctor123` |
| **Full Name** | Dr. Sarah Johnson |
| **Employee ID** | EMP002 |
| **Email** | sarah.j@citygeneralhospital.com |
| **Department** | Cardiology |
| **Doctor Number** | DOC001 |
| **Consultation Fee** | $150.00 |

**Capabilities:**
- ✅ Patient consultations
- ✅ Prescribe medications
- ✅ Request lab tests
- ✅ View patient medical history
- ✅ Access nurse station
- ✅ View appointments

**Key Modules:**
- Consultation
- Patients (view only)
- Nurse Station

---

## 💊 Pharmacist

**Access:** Pharmacy and drug dispensing

| Field | Value |
|-------|-------|
| **Username** | `pharmacist1` |
| **Password** | `pharm123` |
| **Full Name** | John Pharmacist |
| **Employee ID** | EMP003 |
| **Email** | john.p@citygeneralhospital.com |
| **Department** | Pharmacy |

**Capabilities:**
- ✅ Manage pharmacy inventory
- ✅ Dispense prescribed drugs
- ✅ Generate pharmacy invoices
- ✅ Add/edit/delete drugs
- ✅ Set drug prices
- ✅ View prescription history

**Key Modules:**
- Pharmacy (full CRUD)
- Rx Dispensing
- Pharmacy Prescriptions

---

## 👩‍⚕️ Nurse

**Access:** Patient care and vital signs

| Field | Value |
|-------|-------|
| **Username** | `nurse` |
| **Password** | `nurse123` |
| **Full Name** | Emily Nurse |
| **Employee ID** | EMP004 |
| **Email** | emily.n@citygeneralhospital.com |
| **Department** | Nursing |

**Capabilities:**
- ✅ Search patients
- ✅ Record vital signs
- ✅ View medical history
- ✅ Patient monitoring

**Key Modules:**
- Nurse Station
- Patients (view only)

---

## 🔬 Lab Scientist

**Access:** Laboratory test processing

| Field | Value |
|-------|-------|
| **Username** | `lab_scientist` |
| **Password** | `lab123` |
| **Full Name** | Michael Lab |
| **Employee ID** | EMP005 |
| **Email** | michael.l@citygeneralhospital.com |
| **Department** | Laboratory |

**Capabilities:**
- ✅ Manage lab test catalog
- ✅ Process lab test requests
- ✅ Generate lab invoices
- ✅ Enter test results
- ✅ Add/edit/delete tests

**Key Modules:**
- Laboratory (full CRUD)
- Lab Requests

---

## 🧪 Lab Technician

**Access:** Laboratory test assistance

| Field | Value |
|-------|-------|
| **Username** | `lab_technician` |
| **Password** | `labtech123` |
| **Full Name** | Sarah LabTech |
| **Employee ID** | EMP006 |
| **Email** | sarah.lt@citygeneralhospital.com |
| **Department** | Laboratory |

**Capabilities:**
- ✅ View lab test requests
- ✅ Process lab tests
- ✅ Generate lab invoices
- ✅ Enter test results
- ✅ View test catalog

**Key Modules:**
- Laboratory (view only)
- Lab Requests

---

## 💉 Pharmacy Technician

**Access:** Pharmacy assistance

| Field | Value |
|-------|-------|
| **Username** | `pharmacy_technician` |
| **Password** | `pharmtech123` |
| **Full Name** | David PharmTech |
| **Employee ID** | EMP007 |
| **Email** | david.pt@citygeneralhospital.com |
| **Department** | Pharmacy |

**Capabilities:**
- ✅ View pharmacy inventory
- ✅ Dispense drugs
- ✅ Generate invoices
- ✅ View drug catalog

**Key Modules:**
- Pharmacy (view only)
- Rx Dispensing

---

## 💰 Accountant

**Access:** Billing and payment processing

| Field | Value |
|-------|-------|
| **Username** | `accountant` |
| **Password** | `account123` |
| **Full Name** | Lisa Accountant |
| **Employee ID** | EMP008 |
| **Email** | lisa.a@citygeneralhospital.com |
| **Department** | Finance |

**Capabilities:**
- ✅ View all invoices
- ✅ Mark payments as paid
- ✅ Print receipts
- ✅ Record payment methods
- ✅ Payment reports
- ❌ Cannot edit amounts
- ❌ Cannot delete invoices

**Key Modules:**
- Billing (payment management)
- Receipt printing

---

## 📋 Record Manager

**Access:** Patient registration and records

| Field | Value |
|-------|-------|
| **Username** | `record_manager` |
| **Password** | `record123` |
| **Full Name** | James Recorder |
| **Employee ID** | EMP009 |
| **Email** | james.r@citygeneralhospital.com |
| **Department** | Records |

**Capabilities:**
- ✅ Register new patients
- ✅ Generate patient cards
- ✅ Update patient information
- ✅ View patient history
- ✅ Patient search

**Key Modules:**
- Patients (full CRUD)
- Patient Cards

---

## 📞 Receptionist

**Access:** Front desk and basic operations

| Field | Value |
|-------|-------|
| **Username** | `receptionist` |
| **Password** | `reception123` |
| **Full Name** | Anna Reception |
| **Employee ID** | EMP010 |
| **Email** | anna.r@citygeneralhospital.com |
| **Department** | Front Desk |

**Capabilities:**
- ✅ Create restaurant meal orders
- ✅ Patient search
- ✅ Basic patient lookup
- ✅ Appointment scheduling assistance

**Key Modules:**
- Meal Orders
- Patients (view only)
- Appointments (view only)

---

## 🍳 Cook

**Access:** Restaurant and meal services

| Field | Value |
|-------|-------|
| **Username** | `cook` |
| **Password** | `cook123` |
| **Full Name** | Carlos Cook |
| **Employee ID** | EMP011 |
| **Email** | carlos.c@citygeneralhospital.com |
| **Department** | Kitchen |

**Capabilities:**
- ✅ Create meal orders
- ✅ Manage restaurant menu
- ✅ Generate food invoices
- ✅ Order history

**Key Modules:**
- Restaurant (full CRUD)
- Meal Orders

---

## 🧹 Cleaner

**Access:** Housekeeping services

| Field | Value |
|-------|-------|
| **Username** | `cleaner` |
| **Password** | `clean123` |
| **Full Name** | Maria Cleaner |
| **Employee ID** | EMP012 |
| **Email** | marcia.c@citygeneralhospital.com |
| **Department** | Housekeeping |

**Capabilities:**
- ✅ View attendance
- ✅ Mark own attendance
- ✅ View profile
- ✅ Change password

**Key Modules:**
- Attendance
- Profile

---

## 📝 Administrative Staff

**Access:** General administrative tasks

| Field | Value |
|-------|-------|
| **Username** | `admin_staff` |
| **Password** | `adminstaff123` |
| **Full Name** | Robert Admin |
| **Employee ID** | EMP013 |
| **Email** | robert.as@citygeneralhospital.com |
| **Department** | Administration |

**Capabilities:**
- ✅ View modules
- ✅ Basic data entry
- ✅ Attendance management
- ✅ Profile management

**Key Modules:**
- Attendance
- Various view-only modules

---

## 🔄 Changing Passwords

### First Login - Security Alert

When you log in with a default password, you will see a **Security Alert** on your profile page:

```
⚠️ Security Alert: You are using a default password!
For your account security, you must change your password immediately.
```

### How to Change Password

1. **Login** with your credentials
2. Click **"My Profile"** in the top menu
3. Scroll to **"Change Password"** section
4. Enter:
   - Current Password
   - New Password (minimum 6 characters)
   - Confirm New Password
5. Click **"Change Password"**

### Password Requirements

- ✅ At least 6 characters long
- ✅ Must match current password
- ✅ New password and confirmation must match

---

## 🚀 Quick Login Reference

### For Testing Complete Workflow

| Role | Username | Password | Main Purpose |
|------|----------|----------|--------------|
| **Super Admin** | `superadmin` | `superadmin123` | System administration |
| **Hospital Admin** | `admin` | `admin123` | Hospital management |
| **Doctor** | `doctor1` | `doctor123` | Consultations & prescriptions |
| **Nurse** | `nurse` | `nurse123` | Vital signs recording |
| **Pharmacist** | `pharmacist1` | `pharm123` | Drug dispensing |
| **Lab Scientist** | `lab_scientist` | `lab123` | Lab test processing |
| **Accountant** | `accountant` | `account123` | Payment processing |
| **Cook** | `cook` | `cook123` | Meal orders |
| **Record Manager** | `record_manager` | `record123` | Patient registration |

---

## 📊 Module Access Matrix

| Module | Super Admin | Hospital Admin | Doctor | Nurse | Pharmacist | Lab | Accountant | Cook | Reception |
|--------|-------------|----------------|--------|-------|------------|-----|------------|------|-----------|
| Dashboard | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ |
| Users | ✅ | ✅ | ❌ | ❌ | ❌ | ❌ | ❌ | ❌ | ❌ |
| Patients | ✅ | ✅ | View | View | View | View | View | View | View |
| Consultation | ✅ | ✅ | ✅ | ❌ | ❌ | ❌ | ❌ | ❌ | ❌ |
| Rx Dispensing | ✅ | ✅ | ❌ | ❌ | ✅ | ❌ | ❌ | ❌ | ❌ |
| Lab Requests | ✅ | ✅ | ❌ | ❌ | ❌ | ✅ | ❌ | ❌ | ❌ |
| Meal Orders | ✅ | ✅ | ❌ | ❌ | ❌ | ❌ | ❌ | ✅ | ✅ |
| Billing | ✅ | ✅ | View | View | View | View | ✅ | View | View |
| Receipts | ✅ | ✅ | ❌ | ❌ | ❌ | ❌ | ✅ | ❌ | ❌ |
| Nurse Station | ✅ | ✅ | ✅ | ✅ | ❌ | ❌ | ❌ | ❌ | ❌ |
| Settings | ✅ | ✅ | ❌ | ❌ | ❌ | ❌ | ❌ | ❌ | ❌ |
| Pharmacy | ✅ | ✅ | View | View | ✅ | View | View | View | View |
| Laboratory | ✅ | ✅ | View | View | View | ✅ | View | View | View |
| Restaurant | ✅ | ✅ | View | View | View | View | View | ✅ | View |
| Attendance | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ |

---

## 🔑 Special Features

### 1. Auto-Login Warning
- System detects default password usage
- Prominent security alert displayed
- Shows current password for easy reference

### 2. Role-Based Navigation
- Menu items change based on role
- Only relevant modules shown
- Clean, uncluttered interface

### 3. Cross-Module Integration
- Doctor consultations → Pharmacy → Lab → Billing
- Seamless workflow between departments
- Automatic invoice generation

### 4. Demo Data Included
- Sample patient: John Smith (PAT001)
- Sample drugs: Paracetamol, Amoxicillin, Ibuprofen
- Sample lab tests: CBC, Blood Glucose, Lipid Profile
- Sample menu items: Grilled Chicken, Vegetable Soup, Fruit Salad

---

## 📞 Support

### Common Issues

**Forgot Password?**
- Contact Hospital Admin to reset
- Super Admin can reset any password

**Can't Access Module?**
- Check your role permissions
- Contact Hospital Admin for access

**Password Change Failed?**
- Verify current password is correct
- Ensure new password is 6+ characters
- Confirm password matches

**Login Failed?**
- Check username spelling
- Verify password is correct
- Ensure correct login page (admin vs super admin)

---

## 🎯 Complete Test Workflow

Use these accounts to test full patient journey:

1. **Record Manager** (`record_manager` / `record123`)
   - Register patient

2. **Nurse** (`nurse` / `nurse123`)
   - Record vital signs

3. **Doctor** (`doctor1` / `doctor123`)
   - Consultation + Prescription + Lab Tests

4. **Pharmacist** (`pharmacist1` / `pharm123`)
   - Dispense drugs + Generate invoice

5. **Lab Scientist** (`lab_scientist` / `lab123`)
   - Process lab tests + Generate invoice

6. **Accountant** (`accountant` / `account123`)
   - Mark payments as paid + Print receipts

7. **Cook** (`cook` / `cook123`)
   - Create meal orders

---

## 📝 System Information

- **Version:** 3.0.0
- **Hospital:** City General Hospital
- **Tenant:** demo
- **Database:** SQLite (hospital_system.db)
- **Status:** Production Ready

---

## 🚪 Getting Started

1. Open browser and navigate to: `http://your-domain.com/`
2. Choose login type:
   - **Super Admin:** Click "Super Admin" link
   - **All Users:** Use main login form
3. Enter credentials from above
4. Click "Login"
5. Change password if prompted
6. Start using the system!

---

**⚠️ Important:** All users should change their passwords immediately after first login for security purposes.

---

**Document Version:** 1.0
**Last Updated:** January 31, 2026
**System Version:** 3.0.0
