# Hospital Management System - Deployment Guide

## Quick Installation (Shared Hosting)

### Step 1: Upload Files
1. Extract the ZIP file
2. Upload ALL files to your public_html folder (or www folder)
3. Make sure all files and folders are uploaded

### Step 2: Set Permissions
Make sure the following are writable (755 permission):
- The root folder (public_html)
- The `pages/` folder
- The `config.php` file

### Step 3: Run Auto-Installer
1. Open your browser
2. Go to: `http://yourdomain.com/install.php`
3. The installer will automatically:
   - Create the database
   - Create all tables
   - Seed demo data
   - Create 14 demo user accounts
4. Follow the on-screen instructions

### Step 4: Delete Installer
For security, delete `install.php` after installation:
```bash
rm install.php
```

### Step 5: Login!
Use these credentials:

**Hospital Admin:**
- URL: `http://yourdomain.com/?action=admin_login`
- Username: `admin`
- Password: `admin123`

**Staff Login (Doctor, Nurse, Pharmacist, etc.):**
- URL: `http://yourdomain.com/?action=staff_login`
- Doctor: `doctor1` / `doctor123`
- Nurse: `nurse` / `nurse123`
- Pharmacist: `pharmacist1` / `pharm123`
- See `DEMO_CREDENTIALS.md` for all 14 accounts

**Super Admin:**
- URL: `http://yourdomain.com/?action=super_login`
- Username: `superadmin`
- Password: `superadmin123`

---

## Requirements

- PHP 8.0 or higher
- SQLite3 extension (enabled by default on most hosts)
- 50 MB disk space
- No MySQL required (uses SQLite)

---

## Features

✅ Multi-tenant hospital management
✅ Patient registration & records
✅ Doctor consultation management
✅ Pharmacy & prescriptions
✅ Laboratory tests & results
✅ Restaurant/meal orders
✅ Billing & invoicing
✅ Nurse observations & vital signs
✅ Patient reports
✅ Role-based access control
✅ 14 user roles with different permissions

---

## File Structure

```
public_html/
├── index.php (main entry point)
├── config.php (database & configuration)
├── install.php (auto-installer - DELETE after use)
├── hospital_system.db (SQLite database - auto-created)
├── pages/ (all module pages)
│   ├── home.php
│   ├── login.php
│   ├── staff_login.php
│   ├── admin_login.php
│   ├── super_login.php
│   ├── dashboard.php
│   ├── patients.php
│   ├── doctors.php
│   ├── consultation.php
│   ├── pharmacy_prescriptions.php
│   ├── lab_requests.php
│   ├── restaurant_orders.php
│   ├── nurse_observations.php
│   ├── patient_reports.php
│   └── ... (more modules)
└── *.md (documentation files)
```

---

## Support

For detailed documentation, see:
- `IMPLEMENTATION_SUMMARY.md` - Complete feature summary
- `ROLE_PERMISSIONS_GUIDE.md` - User role permissions
- `DEMO_CREDENTIALS.md` - All demo accounts
- `PATIENT_REPORTS_GUIDE.md` - Patient reporting guide
- `LOGIN_GUIDE.md` - Three login portals guide
- `COMPLETE_WORKFLOW_GUIDE.md` - End-to-end workflows

---

## Troubleshooting

**Blank pages:**
- Make sure all files are uploaded
- Check PHP version (require PHP 8.0+)
- Verify SQLite3 extension is enabled

**Login not working:**
- Use correct login portal (staff/admin/super)
- Check username/password in DEMO_CREDENTIALS.md
- Clear browser cache

**Database errors:**
- Make sure folder is writable (755)
- Run install.php again
- Check that hospital_system.db exists

**Permission denied:**
- You're using wrong login for your role
- Hospital Admin: use ?action=admin_login
- Staff: use ?action=staff_login
- Super Admin: use ?action=super_login

---

## Security Notes

1. Delete `install.php` after installation
2. Change default passwords after first login
3. Keep database file (.db) outside public folder if possible
4. Use HTTPS in production
5. Regular backups of hospital_system.db

---

## Version: 2.4.0
## Last Updated: 2026-02-02
