# Hospital Management System - Login Guide

## Three Distinct Login Interfaces

The system now has **three separate login portals** based on user type:

---

## 1. STAFF LOGIN (Blue Theme)
**URL:** `index.php?action=staff_login`

**Who uses this:**
- Doctors
- Nurses
- Pharmacists
- Lab Scientists & Technicians
- Accountants
- Cooks
- Receptionists
- Record Managers
- Cleaners
- All hospital employees

**Demo Credentials:**
| Role | Username | Password |
|------|----------|----------|
| Doctor | `doctor1` | `doctor123` |
| Nurse | `nurse` | `nurse123` |
| Pharmacist | `pharmacist1` | `pharm123` |
| Lab Scientist | `lab_scientist` | `lab123` |
| Lab Technician | `lab_technician` | `labtech123` |
| Accountant | `accountant` | `account123` |
| Cook | `cook` | `cook123` |
| Receptionist | `receptionist` | `reception123` |
| Record Manager | `record_manager` | `record123` |
| Pharmacy Tech | `pharmacy_technician` | `pharmtech123` |
| Admin Staff | `admin_staff` | `adminstaff123` |
| Cleaner | `cleaner` | `clean123` |

---

## 2. HOSPITAL ADMIN LOGIN (Green Theme)
**URL:** `index.php?action=admin_login`

**Who uses this:**
- Hospital Administrator (single main admin per hospital)

**Demo Credentials:**
| Role | Username | Password |
|------|----------|----------|
| Hospital Admin | `admin` | `admin123` |

**Special Privileges:**
- Manage all users in the hospital
- Configure hospital settings
- Access all reports and analytics
- Manage doctors, patients, appointments
- Full access to all modules

---

## 3. SUPER ADMIN LOGIN (Red Theme)
**URL:** `index.php?action=super_login`

**Who uses this:**
- System Administrator (manages entire multi-tenant system)

**Demo Credentials:**
| Role | Username | Password |
|------|----------|----------|
| Super Admin | `superadmin` | `superadmin123` |

**Special Privileges:**
- Manage all hospitals/tenants
- Create new hospitals
- Manage users across all hospitals
- System-wide analytics
- Database management

---

## Login Selection Page

When users visit the home page, they will see **three login cards**:

### Staff Login Card (Blue)
- For doctors, nurses, pharmacists, lab staff, accountants, cooks, and all hospital employees
- Redirects to: `?action=staff_login`

### Hospital Admin Card (Green)
- For hospital administrators who manage settings and users
- Redirects to: `?action=admin_login`

### Super Admin Card (Red)
- For system administrators who manage all hospitals
- Redirects to: `?action=super_login`

---

## Quick Access Links

### For Testing:
1. **Home Page:** `index.php` or `index.php?action=home`
2. **Staff Login:** `index.php?action=staff_login`
3. **Hospital Admin Login:** `index.php?action=admin_login`
4. **Super Admin Login:** `index.php?action=super_login`

### Alternative Testing Pages:
- **Direct Login (with debug):** `direct_login.php`
- **Test Login (one-click buttons):** `test_login.php`
- **System Diagnostics:** `diagnostics.php`

---

## Features of Each Login Page

### All Login Pages Include:
1. Distinct color theme (Blue/Green/Red)
2. Clear role description
3. Dedicated login form
4. Demo credentials display
5. "Back to Login Selection" link
6. Responsive design for mobile/tablet/desktop

### Security Features:
- Tenant ID validation
- Password hashing (BCrypt)
- Session-based authentication
- Role-based access control
- Default password detection (shows warning on first login)

---

## After Login

### Staff users see:
- Dashboard
- Patients, Doctors, Appointments
- Consultation (for doctors)
- Pharmacy Prescriptions (for pharmacists)
- Lab Requests (for lab staff)
- Restaurant Orders (for cooks)
- Billing/Accounting (for accountants)
- Nurse Station (for nurses/doctors)
- Profile & Password Change

### Hospital Admin sees:
- All staff features PLUS:
- User Management
- Hospital Settings
- System Configuration
- Full Reports & Analytics

### Super Admin sees:
- Super Admin Dashboard
- All Hospitals Management
- All Users (across all hospitals)
- System Reports
- Tenant Creation/Management

---

## Password Change

**All users** should change their password on first login:
1. Go to "My Profile" after logging in
2. You'll see a security alert if using default password
3. Enter new password and confirm
4. Click "Change Password"

**Default passwords are shown on each login page for demo purposes.**

---

## Troubleshooting

### "Invalid username or password"
1. Make sure you're using the correct login page for your role
2. Verify username and password (case-sensitive)
3. Check you're accessing the correct hospital/tenant
4. Try using the debug pages: `direct_login.php` or `test_login.php`

### Can't access a feature?
- Check your role permissions
- Some features are role-specific (e.g., only doctors can consult)
- Contact hospital admin to verify your account setup

### Wrong login page?
- Click "Back to Login Selection" to return to home page
- Choose the correct login type for your role

---

## Contact

For issues or questions about the login system, check:
- `DEMO_CREDENTIALS.md` - Full list of all demo accounts
- `COMPLETE_WORKFLOW_GUIDE.md` - Detailed system workflows
- `diagnostics.php` - System health check

---

**Version:** 2.3.0
**Last Updated:** 2026-02-01
