# Patient Reports System - User Guide

## Overview

The Patient Reports system allows authorized healthcare staff to write comprehensive reports on patient care, observations, and activities. Each patient automatically has a dedicated space where authorized users can create and view reports.

---

## Who Can Write Patient Reports?

Only the following 6 roles have access to the Patient Reports module:

1. **Nurse** - Patient care and monitoring reports
2. **Doctor** - Clinical assessments and treatment plans
3. **Pharmacist** - Medication management reports
4. **Pharmacy Technician** - Drug dispensing and counseling
5. **Lab Scientist** - Laboratory results and analysis
6. **Lab Technician** - Test results and specimen handling

---

## How to Access Patient Reports

### Navigation:
1. Login with one of the authorized roles
2. Click on **"Patient Reports"** in the top navigation menu
3. URL: `index.php?action=patient_reports`

---

## Using the Patient Reports System

### Step 1: Search for a Patient
1. Enter patient name or patient number in the search box
2. Click "Search"
3. Select the patient from the search results

### Step 2: View Patient Information
Once a patient is selected, you'll see:
- Patient Number
- Full Name
- Gender & Age
- Contact Information

### Step 3: Write a New Report
Fill in the following fields:

#### Report Type
Different report types are available based on your role:

**Nurses can write:**
- Nursing Assessment
- Vital Signs Observation
- Nursing Care Plan
- Patient Progress
- Wound Care
- Medication Administration

**Doctors can write:**
- Clinical Assessment
- Diagnosis Report
- Treatment Plan
- Follow-up Consultation
- Discharge Summary
- Specialist Review

**Pharmacists/Pharmacy Technicians can write:**
- Medication Dispensing
- Drug Interaction Check
- Pharmaceutical Care
- Patient Counseling
- Medication Review

**Lab Scientists/Lab Technicians can write:**
- Laboratory Results
- Test Analysis
- Specimen Collection
- Quality Control
- Test Interpretation

**All roles can also write:**
- General Observation
- Other

#### Report Title
- Brief, descriptive title (max 200 characters)
- Example: "Post-operative wound assessment - Day 3"

#### Report Content
- Comprehensive details about your observations
- Include:
  - Current observations/findings
  - Assessments performed
  - Actions taken
  - Patient response
  - Recommendations
  - Follow-up required

### Step 4: Submit Report
Click "Submit Report" to save the report. A unique report number will be generated (format: RPT20260201-0001)

---

## Viewing Previous Reports

### Report Display Features:

1. **Color-Coded by Role:**
   - Doctor reports: Yellow background
   - Nurse reports: Blue background
   - Pharmacist reports: Green background
   - Lab staff reports: Pink background

2. **Report Information:**
   - Report Number (e.g., RPT20260201-0001)
   - Report Type
   - Report Title
   - Full Content
   - Written by (staff name and role)
   - Date and time

3. **Chronological Order:**
   - Most recent reports appear first
   - Easy to track patient care timeline

---

## Report Numbering System

Reports are automatically numbered using the format:
- **RPT** (prefix)
- **YYYYMMDD** (date: 20260201)
- **-XXXX** (sequential number: 0001, 0002, etc.)

Example: `RPT20260201-0001`

---

## Use Cases by Role

### Nurses
**Use patient reports for:**
- Recording vital signs observations
- Documenting wound care procedures
- Tracking patient progress over shifts
- Recording medication administration
- Noting patient complaints or concerns
- Handover notes between shifts

### Doctors
**Use patient reports for:**
- Clinical assessments and examinations
- Diagnosis documentation
- Treatment plan updates
- Follow-up consultation notes
- Discharge planning
- Specialist reviews and opinions

### Pharmacists/Pharmacy Technicians
**Use patient reports for:**
- Drug interaction warnings
- Patient counseling sessions
- Medication review outcomes
- Dispensing notes and instructions
- Adverse drug reaction documentation
- Pharmaceutical care plans

### Lab Scientists/Lab Technicians
**Use patient reports for:**
- Laboratory test results
- Specimen quality notes
- Test interpretation and analysis
- Quality control observations
- Critical value notifications
- Follow-up test recommendations

---

## Best Practices

### Writing Effective Reports:

1. **Be Specific and Detailed**
   - Include exact times, measurements, and observations
   - Use objective language
   - Document facts, not assumptions

2. **Use Professional Language**
   - Clear and concise
   - Medical terminology when appropriate
   - Avoid abbreviations that may be unclear

3. **Include All Relevant Information**
   - What you observed
   - What you did
   - Patient's response
   - Any concerns or recommendations

4. **Timeliness**
   - Write reports as soon as possible after the event
   - While details are fresh in your memory

5. **Follow-up**
   - Note any required follow-up actions
   - Mention who should be informed
   - Document handover information

### Example Report:

**Report Type:** Nursing Assessment
**Title:** Post-operative vital signs monitoring - 2 hours post-surgery

**Content:**
```
Patient returned to ward at 14:00 following appendectomy under general anesthesia.

Vital Signs (14:30):
- Blood Pressure: 120/80 mmHg
- Heart Rate: 78 bpm (regular rhythm)
- Respiratory Rate: 16 breaths/min
- Temperature: 37.2°C
- SpO2: 98% on room air

Assessment:
- Patient is alert and oriented x3
- Surgical wound dressing clean and dry, no visible bleeding
- Pain score: 4/10, managed with prescribed analgesia
- No nausea or vomiting reported
- IV line patent, normal saline running at 125ml/hr

Actions Taken:
- Administered Tramadol 50mg IV as prescribed
- Encouraged deep breathing exercises
- Patient able to move all extremities
- Call bell within reach

Plan:
- Continue vital signs monitoring every 2 hours
- Encourage early mobilization as per surgeon's orders
- Monitor for signs of infection
- Pain assessment before next dose due at 18:30

Next assessment due: 16:30
Written by: Emily Nurse, RN
```

---

## Security and Privacy

- All reports are stored securely in the database
- Reports are linked to specific patients and tenants
- Only authorized roles can view and write reports
- Each report tracks who wrote it and when
- Reports cannot be edited once submitted (audit trail)

---

## Access Requirements

### To Write Reports:
1. Must be logged in with one of the 6 authorized roles
2. Must select a patient first
3. All fields are required

### To View Reports:
1. Same role restrictions apply
2. Can view all reports for a selected patient
3. Reports from all roles are visible (collaborative care)

---

## Technical Details

### Database Table: `patient_reports`
- Stores all patient reports
- Auto-generates report numbers
- Tracks writer information (user ID, role, name)
- Timestamps for audit trail
- Linked to patients and tenants

### Integration:
- Accessible from main navigation menu
- Role-based access control
- Multi-tenant support (hospital isolation)
- Responsive design for mobile/tablet use

---

## Troubleshooting

### "Access Denied" Error
- Check that you're logged in with an authorized role
- Only Nurse, Doctor, Pharmacist, Pharmacy Technician, Lab Scientist, and Lab Technician can access

### Can't Find a Patient
- Verify patient number or name spelling
- Check that patient exists in the system
- Patient must belong to your hospital/tenant

### Report Not Submitting
- Ensure all required fields are filled
- Report content cannot be empty
- Report title must be under 200 characters

---

## Quick Reference

**URL:** `?action=patient_reports`

**Authorized Roles:**
- nurse
- doctor
- pharmacist
- pharmacy_technician
- lab_scientist
- lab_technician

**Report Number Format:** RPT + YYYYMMDD + sequential number

**Features:**
- Patient search
- Role-specific report types
- Comprehensive report writing
- Previous reports viewing
- Color-coded by role
- Automatic timestamping

---

**Version:** 2.3.0
**Last Updated:** 2026-02-01
