# Hospital Management System v3.0 - Quick Reference

## Complete Patient Care Workflow

---

## 🎯 Quick Workflows

### 1️⃣ DOCTOR: Consult & Prescribe
```
Login → Consultation → Search Patient → Start Consultation
→ Fill: Chief Complaint, Diagnosis → Add Drugs (optional)
→ Request Lab Tests (optional) → Save
```

**Result:** Prescription + Lab Request created

---

### 2️⃣ PHARMACIST: Dispense Drugs
```
Login → Rx Dispensing → View Pending → Select Prescription
→ Check Stock → Select Drugs → Dispense & Generate Invoice
```

**Result:** Invoice created → Inventory updated

---

### 3️⃣ LAB: Process Tests
```
Login → Lab Requests → View Request → Select Tests
→ Generate Invoice → (Patient pays) → Enter Results → Save
```

**Result:** Invoice created → Results saved

---

### 4️⃣ COOK: Meal Orders
```
Login → Meal Orders → Search Patient → Select Items
→ Create Order & Generate Invoice
```

**Result:** Invoice created → Order prepared after payment

---

### 5️⃣ ACCOUNTANT: Process Payments
```
Login → Billing → Find Invoice → Mark as Paid
→ Select Payment Method → Click "📄 Receipt"
```

**Result:** Invoice marked paid → Receipt prints

---

## 📊 Module Access by Role

| Module | Doctor | Pharmacist | Lab | Cook | Accountant | Admin |
|--------|--------|------------|-----|------|------------|-------|
| Consultation | ✅ | ❌ | ❌ | ❌ | ❌ | ✅ |
| Rx Dispensing | ❌ | ✅ | ❌ | ❌ | ❌ | ✅ |
| Lab Requests | ❌ | ❌ | ✅ | ❌ | ❌ | ✅ |
| Meal Orders | ❌ | ❌ | ❌ | ✅ | ❌ | ✅ |
| Billing | View | View | View | View | ✅ | ✅ |
| Receipts | ❌ | ❌ | ❌ | ❌ | ✅ | ✅ |

---

## 🔗 Workflow Links

### Patient Journey
```
Registration
→ Nurse Station (Vitals)
→ Consultation (Doctor)
→ ├→ Pharmacy (Rx)
→ │   → Billing (Pay)
→ │   → Receipt
→ │   → Collect Drugs
→ └→ Lab (Tests)
    → Billing (Pay)
    → Receipt
    → Lab Results
    → Doctor Review
```

### Restaurant Journey
```
Meal Order (Cook)
→ Invoice Generated
→ Billing (Pay)
→ Receipt
→ Meal Service
```

---

## 💡 Key Features

### Consultation Module
- ✅ Patient search (number/name)
- ✅ Medical history (last 5)
- ✅ Drug prescription (multiple)
- ✅ Lab test requests (multiple)
- ✅ Auto-generates PRX and LR numbers

### Pharmacy Dispensing
- ✅ Stock availability check
- ✅ Multiple item selection
- ✅ Auto-pricing from inventory
- ✅ Invoice generation
- ✅ Auto-inventory update

### Lab Processing
- ✅ Two-stage: Invoice → Results
- ✅ Test result entry
- ✅ Reference range support
- ✅ Performed-by tracking
- ✅ Status management

### Restaurant Orders
- ✅ Patient search
- ✅ Menu-based ordering
- ✅ Real-time total calculation
- ✅ Auto-invoice generation
- ✅ Special instructions

### Receipt System
- ✅ 80mm thermal format
- ✅ Professional layout
- ✅ Hospital branding
- ✅ Complete payment details
- ✅ Print-ready

---

## 📝 Invoice Numbers

### Format: INV{date}{sequence}
```
INV202601310001  - First invoice of Jan 31, 2026
INV202601310002  - Second invoice
INV202602010001  - First invoice of Feb 1, 2026
```

### Prescription Numbers: PRX{date}{sequence}
### Lab Request Numbers: LR{date}{sequence}
### Food Order Numbers: FOOD{date}{sequence}

---

## 🎨 Navigation Menu

**Staff See:**
- Dashboard
- Patients
- **Consultation** (Doctors only)
- **Rx Dispensing** (Pharmacy only)
- **Lab Requests** (Lab only)
- **Meal Orders** (Cooks only)
- Billing
- Nurse Station
- Settings (Admin only)
- My Profile

---

## ⚡ Quick Actions

### Mark Invoice as Paid
```
Billing → Update button → Select "Paid" →
Select Payment Method → Save
```

### Print Receipt
```
Billing → Find paid invoice → Click "📄 Receipt" → Print
```

### View Lab Results
```
Lab Requests → Find completed request → View results
```

### Check Drug Stock
```
Pharmacy → View inventory → Check quantity column
```

---

## 🔐 Login Credentials

### Super Admin
```
URL: ?action=super_login
User: superadmin
Pass: super123
```

### Hospital Admin
```
URL: ?action=login
User: admin
Pass: admin123
```

### Create More Users
```
Users → Add User → Select Role → Set Credentials
```

---

## 🚨 Common Issues

### Prescription not showing in pharmacy
**Fix:** Check doctor added drugs AND saved consultation

### Can't enter lab results
**Fix:** Invoice must be generated first (status = "invoiced")

### Receipt button missing
**Fix:** Invoice must be marked as "paid" first

### Stock not updating
**Fix:** Must complete "Dispense & Generate Invoice" action

### Can't find patient
**Fix:** Try patient number (PAT00001) OR full name

---

## 📞 Module URLs

```
?action=consultation           # Doctor consultation
?action=pharmacy_prescriptions # Pharmacy dispensing
?action=lab_requests           # Lab test processing
?action=restaurant_orders      # Meal orders
?action=billing                # Billing & payments
?action=receipt&id=XX          # Print receipt
?action=nurse_station          # Nurse vitals
?action=patients               # Patient management
?action=settings               # Hospital settings
```

---

## ✅ Status Indicators

### Prescription Status
- `pending` - Waiting for pharmacy
- `invoiced` - Invoice created
- `dispensed` - Drugs collected

### Lab Request Status
- `pending` - Waiting for lab
- `invoiced` - Invoice created
- `completed` - Results entered

### Payment Status
- `pending` - Not paid
- `paid` - Payment received
- `cancelled` - Cancelled

---

## 🎯 Complete Test Scenario

### Full Patient Journey (15 minutes)

**1. Register Patient**
```
Patients → Add New Patient
Fill: John Smith, DOB, Phone, Email
Save → Patient Number: PAT00001
```

**2. Nurse Records Vitals**
```
Nurse Station → Search "PAT00001" → Record Vitals
Enter: BP 120/80, Temp 98.6, Pulse 72
Save → History updated
```

**3. Doctor Consultation**
```
Consultation → Search "John Smith" → Start Consultation
Chief Complaint: "Fever and headache"
Diagnosis: "Malaria"
Add Drug: Artemether, 500mg, 3x daily, 7 days, 21 tabs
Request Test: Malaria Parasite
Save → PRX00001 & LR00001 created
```

**4. Pharmacy Dispensing**
```
Rx Dispensing → View PRX00001
Check stock: Artemeter (100 available)
Select Artemether
Click: Dispense & Generate Invoice
Invoice: INV00001, $50.00
```

**5. Lab Processing**
```
Lab Requests → View LR00001
Select Malaria Parasite Test
Click: Generate Invoice
Invoice: INV00002, $15.00
Wait for payment...
Enter Result: Positive (+)
Save → Status: completed
```

**6. Payment**
```
Billing → Find INV00001 and INV00002
Mark both as "Paid", Payment Method: Cash
Total: $65.00
```

**7. Receipt & Collection**
```
Billing → Click "📄 Receipt" for INV00001 → Print
Click "📄 Receipt" for INV00002 → Print
Patient takes pharmacy receipt → Collects drugs
Patient takes lab receipt → Gets results
```

**Result:** Complete patient care cycle ✅

---

## 📈 System Stats

### Modules: 18+
### User Roles: 14
### Database Tables: 22
### Navigation Links: 20+
### Automated Workflows: 5

---

## 🎉 What's New in v3.0

✅ Complete doctor consultation workflow
✅ Pharmacy prescription management
✅ Lab test request processing
✅ Restaurant meal ordering
✅ Receipt printing system
✅ Multi-department integration
✅ Automatic invoice generation
✅ Inventory auto-updates
✅ Status tracking throughout
✅ Role-based permissions

---

**Version:** 3.0.0
**Status:** Production Ready
**Date:** January 31, 2026

---
