# Multi-Tenant Hospital Management System

A comprehensive, responsive hospital management system built with PHP 8.4 and SQLite, featuring complete multi-tenant architecture.

## Features

### Core Functionality
- **Multi-Tenant Architecture**: Complete data isolation for multiple hospitals
- **Patient Management**: Register and manage patient records with medical history
- **Doctor Management**: Manage doctor profiles, specializations, and schedules
- **Appointment Scheduling**: Easy appointment booking and management system
- **Billing & Invoicing**: Automated invoice generation and payment tracking
- **Medical Records**: Secure medical records with diagnosis and prescriptions
- **Dashboard**: Real-time statistics and analytics

### Technical Features
- **Responsive Design**: Works seamlessly on mobile, tablet, and desktop
- **SQLite Database**: Lightweight, serverless database with automatic setup
- **Secure Authentication**: Password hashing and session management
- **Modern UI**: Clean, gradient-based design with intuitive navigation
- **Multi-Hospital Support**: Switch between hospitals with tenant selector

## Installation

1. Upload all files to your web server's public_html directory
2. Ensure PHP 8.4 is installed with PDO SQLite extension
3. Access the website through your browser
4. The database will be automatically created on first access

## Demo Credentials

**Username**: admin
**Password**: admin123

## Database Schema

The system automatically creates the following tables:
- `tenants` - Hospital/organization information
- `users` - System users with role-based access
- `patients` - Patient records and information
- `doctors` - Doctor profiles and specializations
- `appointments` - Appointment scheduling
- `billing` - Invoices and payment tracking
- `medical_records` - Patient medical history

## Multi-Tenant System

### How It Works
Each hospital (tenant) has:
- Complete data isolation
- Custom branding (name, logo, contact info)
- Independent user management
- Separate patient and doctor databases

### Switching Hospitals
Use the tenant selector in the footer to switch between different hospital systems.

### Default Tenant
The system comes pre-configured with "City General Hospital" as a demo tenant.

## User Roles

- **Admin**: Full system access
- **Doctor**: Access to appointments and medical records
- **Nurse**: Patient care and appointment management
- **Receptionist**: Front desk operations and scheduling

## File Structure

```
public_html/
├── index.php           # Main application file
├── config.php          # Database and configuration
├── pages/              # Page modules
│   ├── home.php        # Landing page
│   ├── login.php       # Login page
│   ├── dashboard.php   # Main dashboard
│   ├── patients.php    # Patient management
│   ├── doctors.php     # Doctor management
│   ├── appointments.php # Appointment scheduling
│   └── billing.php     # Billing and invoicing
└── hospital_system.db  # SQLite database (auto-created)
```

## Security Features

- Password hashing using PHP's password_hash()
- SQL injection prevention with prepared statements
- Session timeout (1 hour)
- HTML output escaping
- Tenant data isolation
- CSRF protection ready

## Responsive Breakpoints

- **Mobile**: < 480px
- **Tablet**: 480px - 768px
- **Desktop**: > 768px

## Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)

## Requirements

- PHP 8.4 or higher
- PDO SQLite extension
- Apache/Nginx web server
- Modern web browser

## Customization

### Adding a New Hospital

1. Access the database
2. Insert into `tenants` table with unique subdomain
3. Create admin user for the new tenant
4. Switch to the new hospital using the tenant selector

### Styling

All styles are embedded in `index.php` within the `<style>` tag. Modify CSS variables in `:root` for quick color changes:

```css
--primary-color: #2563eb;
--secondary-color: #1e40af;
--success-color: #10b981;
--danger-color: #ef4444;
```

## Support & Documentation

For issues or questions, refer to the inline code comments or contact the system administrator.

## License

This is a custom-built hospital management system. All rights reserved.

## Version

Version 1.0.0 - January 2025
