# Hospital Management System v3.0

## Complete Multi-Tenant Healthcare Management Solution

---

## 🏥 System Overview

A comprehensive, web-based hospital management system built with **PHP 8.4** and **SQLite**, featuring multi-tenant architecture, role-based access control, and complete patient care workflows from consultation through billing.

### Key Features:
- ✅ **Multi-Tenant Architecture** - Multiple hospitals on single installation
- ✅ **14 User Roles** - Granular access control
- ✅ **Complete Patient Care** - Registration → Consultation → Treatment → Billing
- ✅ **Prescription Management** - Electronic prescribing with pharmacy integration
- ✅ **Laboratory System** - Test requests, processing, and results
- ✅ **Restaurant Services** - Meal ordering with automatic invoicing
- ✅ **Billing & Receipts** - Complete payment tracking with thermal receipts
- ✅ **Patient Cards** - Business card-sized ID generation
- ✅ **Nurse Station** - Vital signs recording and patient monitoring
- ✅ **Demo Users** - 14 pre-configured accounts for testing

---

## 🚀 Quick Start

### 1. System Check
Run the validation script to verify your installation:
```bash
http://your-domain.com/system_check.php
```

### 2. Login

**Super Admin:**
- URL: `?action=super_login`
- Username: `superadmin`
- Password: `superadmin123`

**Hospital Admin:**
- URL: `?action=login`
- Username: `admin`
- Password: `admin123`

### 3. Change Password
All users should change their passwords after first login:
1. Click **"My Profile"** in top menu
2. You'll see a security alert (if using default password)
3. Fill in the **Change Password** form
4. Your current password is shown in the alert
5. Enter new password (minimum 6 characters)
6. Click **"Change Password"**

---

## 👥 All Demo Users

| Role | Username | Password | Purpose |
|------|----------|----------|---------|
| Super Admin | `superadmin` | `superadmin123` | System administration |
| Hospital Admin | `admin` | `admin123` | Hospital management |
| Doctor | `doctor1` | `doctor123` | Consultations & prescriptions |
| Pharmacist | `pharmacist1` | `pharm123` | Drug dispensing |
| Nurse | `nurse` | `nurse123` | Vital signs recording |
| Lab Scientist | `lab_scientist` | `lab123` | Lab test processing |
| Lab Technician | `lab_technician` | `labtech123` | Lab test assistance |
| Pharmacy Tech | `pharmacy_technician` | `pharmtech123` | Pharmacy assistance |
| Accountant | `accountant` | `account123` | Payment processing |
| Record Manager | `record_manager` | `record123` | Patient registration |
| Receptionist | `receptionist` | `reception123` | Front desk duties |
| Cook | `cook` | `cook123` | Meal preparation |
| Cleaner | `cleaner` | `clean123` | Housekeeping |
| Admin Staff | `admin_staff` | `adminstaff123` | General admin |

**See [DEMO_CREDENTIALS.md](DEMO_CREDENTIALS.md) for complete details.**

---

## 📊 Complete Workflow

### Patient Registration & Care Journey

```
1. REGISTRATION (Record Manager)
   ├─ Patient Registration
   ├─ Patient Card Generation
   └─ Card Fee Invoice Created

2. NURSE STATION (Nurse)
   ├─ Patient Search
   ├─ Vital Signs Recording
   └─ Medical History

3. CONSULTATION (Doctor)
   ├─ Patient Examination
   ├─ Diagnosis Entry
   ├─ Drug Prescription
   └─ Lab Test Requests

4a. PHARMACY (Pharmacist)
    ├─ View Prescription
    ├─ Check Stock
    ├─ Dispense Drugs
    └─ Generate Invoice

4b. LABORATORY (Lab Scientist)
    ├─ View Test Requests
    ├─ Generate Invoice
    ├─ Perform Tests (after payment)
    └─ Enter Results

5. BILLING (Accountant)
   ├─ Process Invoices
   ├─ Mark as Paid
   └─ Print Receipts

6a. DRUG COLLECTION
    └─ Patient collects dispensed drugs

6b. LAB RESULTS
    └─ Doctor reviews test results

7. RESTAURANT (Cook)
   ├─ Create Meal Order
   ├─ Generate Invoice
   └─ Prepare & Serve Meal
```

---

## 🎯 Core Modules

### 1. Doctor Consultation
**Access:** Doctor, Hospital Admin
- Patient search (number/name)
- Medical history review
- Examination notes
- Drug prescribing (multiple items)
- Lab test requests (multiple tests)
- Auto-generates prescriptions and lab requests

### 2. Pharmacy Dispensing
**Access:** Pharmacist, Pharmacy Technician, Hospital Admin
- View pending prescriptions
- Stock availability check
- Drug selection and dispensing
- Automatic pricing
- Invoice generation
- Inventory auto-update

### 3. Lab Test Processing
**Access:** Lab Scientist, Lab Technician, Hospital Admin
- View pending test requests
- Select performable tests
- Invoice generation
- Result entry (after payment)
- Reference ranges
- Results history

### 4. Restaurant Orders
**Access:** Cook, Receptionist, Hospital Admin
- Patient search
- Menu-based ordering
- Real-time total calculation
- Automatic invoice generation
- Order tracking

### 5. Billing & Receipts
**Access:** Accountant, Hospital Admin
- View all invoices
- Mark as paid
- Record payment method
- Print thermal receipts (80mm)
- Payment reports

### 6. Nurse Station
**Access:** Nurse, Doctor, Hospital Admin
- Patient search
- Vital signs recording
  - Blood Pressure
  - Temperature
  - Pulse Rate
  - Respiratory Rate
  - Weight, Height
- Medical history

### 7. Patient Cards
**Access:** Record Manager, Hospital Admin
- Business card size (3.5" × 2")
- Professional design
- Print-ready
- Email option
- Hospital branding

---

## 📁 File Structure

```
public_html/
├── config.php                    # Configuration & database
├── index.php                     # Main router & navigation
├── hospital_system.db            # SQLite database
│
├── pages/
│   ├── dashboard.php             # Dashboard
│   ├── login.php                 # User login
│   ├── super_login.php           # Super admin login
│   ├── home.php                  # Public home page
│   ├── profile.php               # User profile & password change
│   ├── settings.php              # Hospital settings
│   ├── users.php                 # User management
│   │
│   ├── patients.php              # Patient management
│   ├── patient_card.php          # Patient card generation
│   ├── doctors.php               # Doctor management
│   ├── consultation.php          # Doctor consultations ✨ NEW
│   ├── appointments.php          # Appointments
│   ├── nurse_station.php         # Nurse station & vital signs
│   │
│   ├── pharmacy.php              # Pharmacy inventory
│   ├── pharmacy_prescriptions.php # Prescription dispensing ✨ NEW
│   │
│   ├── laboratory.php            # Lab test catalog
│   ├── lab_requests.php          # Lab test processing ✨ NEW
│   │
│   ├── restaurant.php            # Restaurant menu
│   ├── restaurant_orders.php     # Meal ordering ✨ NEW
│   │
│   ├── billing.php               # Billing & payments
│   ├── receipt.php               # Receipt printing ✨ NEW
│   ├── admissions.php            # Patient admissions
│   ├── accounting.php            # Accounting
│   ├── attendance.php            # Attendance register
│   │
│   └── register_hospital.php     # Hospital registration
│
├── Documentation/
│   ├── README_v3.md              # This file
│   ├── DEMO_CREDENTIALS.md       # All login credentials
│   ├── QUICK_REFERENCE_v3.md     # Quick reference guide
│   ├── COMPLETE_WORKFLOW_GUIDE.md # Comprehensive guide
│   ├── PATIENT_WORKFLOW.md       # Patient care workflow
│   ├── SYSTEM_GUIDE.md           # System guide
│   └── UPDATES.md                # Update history
│
└── system_check.php              # System validation script ✨ NEW
```

---

## 🗄️ Database Structure

**22 Tables:**
- `tenants` - Hospitals/organizations
- `users` - All system users
- `patients` - Patient records
- `doctors` - Doctor profiles
- `appointments` - Appointments
- `medical_records` - Consultations & exams
- `prescriptions` - Prescriptions header ✨ NEW
- `prescription_items` - Individual drugs ✨ NEW
- `lab_requests` - Lab test requests header ✨ NEW
- `lab_request_items` - Individual tests ✨ NEW
- `lab_tests` - Lab test catalog
- `pharmacy_inventory` - Drug inventory
- `restaurant_menu` - Food menu
- `restaurant_orders` - Meal orders ✨ NEW
- `billing` - Invoices & payments
- `admissions` - Patient admissions
- `attendance` - Staff attendance
- `doctors_on_call` - Doctor schedules
- `doctor_specializations` - Specialties
- `leave_management` - Leave requests
- `payroll` - Employee payroll
- `salaries` - Salary history

---

## 🎨 Navigation

Each role sees a customized menu:

**Hospital Admin:**
- Dashboard, Users, Patients, Doctors, Consultation, Appointments
- Billing, Admissions, Pharmacy, Rx Dispensing, Lab, Lab Requests
- Restaurant, Meal Orders, Accounting, Attendance
- Nurse Station, Settings, Profile

**Doctor:**
- Dashboard, Patients, Consultation, Appointments, Nurse Station, Profile

**Pharmacist:**
- Dashboard, Patients, Pharmacy, Rx Dispensing, Profile

**Lab Scientist:**
- Dashboard, Patients, Laboratory, Lab Requests, Profile

**Accountant:**
- Dashboard, Patients, Billing, Profile

**Nurse:**
- Dashboard, Patients, Nurse Station, Profile

---

## 🔐 Security Features

- ✅ Password hashing (bcrypt)
- ✅ SQL injection prevention (prepared statements)
- ✅ XSS protection (htmlspecialchars)
- ✅ Session management
- ✅ Role-based access control
- ✅ Multi-tenant data isolation
- ✅ Default password detection
- ✅ Forced password change prompt

---

## 📝 Configuration

### Database
```php
define('DB_PATH', __DIR__ . '/hospital_system.db');
```

### Session Timeout
```php
define('SESSION_TIMEOUT', 3600); // 1 hour
```

### Patient Card Fee
Set in Hospital Settings (default: $5.00)

---

## 🧪 Testing

### Run System Check
```bash
http://your-domain.com/system_check.php
```

### Complete Workflow Test
1. **Record Manager** → Register patient
2. **Nurse** → Record vital signs
3. **Doctor** → Consultation + Prescription + Lab Tests
4. **Pharmacist** → Dispense drugs
5. **Lab Scientist** → Process tests
6. **Accountant** → Process payments + Print receipts
7. **Cook** → Create meal order

---

## 📚 Documentation Files

1. **README_v3.md** (this file) - Main documentation
2. **DEMO_CREDENTIALS.md** - All 14 user login details
3. **QUICK_REFERENCE_v3.md** - Quick daily reference
4. **COMPLETE_WORKFLOW_GUIDE.md** - Comprehensive workflow guide
5. **PATIENT_WORKFLOW.md** - Patient registration & care
6. **SYSTEM_GUIDE.md** - Detailed system guide
7. **UPDATES.md** - Version history & updates

---

## 🔄 Version History

### v3.0.0 (January 31, 2026)
✅ Doctor consultation module
✅ Pharmacy prescription dispensing
✅ Lab test request processing
✅ Restaurant meal ordering
✅ Receipt printing system
✅ All 14 user roles with demo accounts
✅ Default password detection
✅ System validation script
✅ Complete documentation

### v2.2.0
✅ Patient card generation
✅ Hospital settings
✅ Nurse station
✅ Vital signs recording

### v2.0.0
✅ Multi-tenant architecture
✅ 14 user roles
✅ Super admin system
✅ Hospital registration

---

## 🎯 Key Workflows

### Prescription Workflow
```
Doctor → Prescribes → Pharmacy → Invoice → Payment → Receipt → Drugs
```

### Lab Test Workflow
```
Doctor → Requests → Lab → Invoice → Payment → Results → Doctor Review
```

### Restaurant Workflow
```
Cook → Order → Invoice → Payment → Meal Preparation → Service
```

### Patient Registration
```
Record Manager → Register → Card Generation → Invoice → Payment → Card Print/Email
```

---

## 🚨 Important Notes

1. **Change Passwords:** All demo users use default passwords - change immediately!
2. **Database:** SQLite database created automatically on first run
3. **Email:** Configure server email settings for email functionality
4. **Backups:** Regular database backups recommended
5. **Session Timeout:** 1 hour of inactivity

---

## 📞 Support

### System Check
Run `system_check.php` to verify installation

### Common Issues
- **Login fails:** Check username/password, ensure correct login page
- **Can't access module:** Verify role permissions
- **Database error:** Ensure hospital_system.db is writable
- **Password change:** Must enter current password correctly

---

## ✅ System Status

**Version:** 3.0.0
**Status:** Production Ready
**PHP Version:** 8.4+
**Database:** SQLite 3
**Architecture:** Multi-tenant
**Users:** 14 demo accounts
**Modules:** 18+
**Tables:** 22

---

## 🎉 Ready to Use!

1. Open browser: `http://your-domain.com/`
2. Run system check: `system_check.php`
3. Login with demo credentials
4. Change password
5. Start managing your hospital!

---

**Built with:** PHP 8.4, SQLite, HTML5, CSS3, JavaScript
**License:** MIT
**Support:** Open Source Community

---

**End of README_v3.md**
