# Role-Based Permissions Guide

## Overview

The Hospital Management System implements **strict role-based access control (RBAC)** where each staff member can only perform tasks specific to their role. Staff members have **read-only (view) access** to other staff's work for collaborative care.

---

## Permission Principle

### ✅ Can Do (Own Role)
- **Full access** to create, edit, and manage tasks within your role
- **Write permissions** for your role-specific modules

### 👁️ Can View (Other Roles)
- **Read-only access** to view work from other healthcare team members
- **No edit or delete permissions** on other staff's work
- View access ensures **collaborative patient care** and continuity

### ❌ Cannot Do
- Cannot perform tasks outside your role
- Cannot modify or delete work created by other staff members
- Cannot access modules not assigned to your role

---

## Detailed Role Permissions

### 1. 👨‍⚕️ DOCTOR

**Can Perform:**
- ✅ Create and manage consultations
- ✅ Write prescriptions (drugs)
- ✅ Request lab tests
- ✅ Write doctor-specific patient reports (Clinical Assessment, Diagnosis, Treatment Plan, etc.)
- ✅ View patient medical history
- ✅ Manage appointments
- ✅ Access nurse station

**Can View (Read-Only):**
- 👁️ Pharmacy dispensing records
- 👁️ Lab test results
- 👁️ Nursing reports and vital signs
- 👁️ Pharmacist reports
- 👁️ Lab technician reports
- 👁️ Billing and payment records

**Cannot Do:**
- ❌ Dispense medications (Pharmacist role)
- ❌ Perform lab tests (Lab staff role)
- ❌ Process payments (Accountant role)
- ❌ Edit/delete reports from other roles

**Modules Access:**
- Consultation (write)
- Patient Reports (write own, view others)
- Appointments (write)
- Patients (view)
- Nurse Station (view/write)
- Medical Records (write)

---

### 2. 👩‍⚕️ NURSE

**Can Perform:**
- ✅ Record vital signs
- ✅ Write nursing reports (Nursing Assessment, Vital Signs Observation, Patient Progress, etc.)
- ✅ Manage patient care activities
- ✅ Access nurse station
- ✅ View patient information

**Can View (Read-Only):**
- 👁️ Doctor consultations and prescriptions
- 👁️ Lab test results
- 👁️ Pharmacy dispensing records
- 👁️ Doctor reports
- 👁️ Pharmacist reports
- 👁️ Lab reports

**Cannot Do:**
- ❌ Write prescriptions (Doctor role)
- ❌ Dispense medications (Pharmacist role)
- ❌ Request lab tests (Doctor role)
- ❌ Process payments (Accountant role)
- ❌ Edit/delete reports from other roles

**Modules Access:**
- Nurse Station (write)
- Patient Reports (write own, view others)
- Patients (view)
- Vital Signs Recording (write)

---

### 3. 💊 PHARMACIST / PHARMACY TECHNICIAN

**Can Perform:**
- ✅ View prescriptions from doctors
- ✅ Dispense medications
- ✅ Generate invoices for dispensed drugs
- ✅ Check drug availability in inventory
- ✅ Write pharmacy reports (Medication Dispensing, Drug Interaction Check, Patient Counseling, etc.)
- ✅ Manage pharmacy inventory

**Can View (Read-Only):**
- 👁️ Doctor prescriptions (to fulfill)
- 👁️ Patient information
- 👁️ Doctor reports
- 👁️ Nursing reports
- 👁️ Lab reports
- 👁️ Payment status (to verify before dispensing)

**Cannot Do:**
- ❌ Write prescriptions (Doctor role)
- ❌ Request lab tests (Doctor role)
- ❌ Perform lab tests (Lab staff role)
- ❌ Modify prescriptions written by doctors
- ❌ Edit/delete reports from other roles

**Modules Access:**
- Pharmacy (view inventory)
- Pharmacy Prescriptions (write - dispense)
- Patient Reports (write own, view others)
- Billing (view payment status)

---

### 4. 🔬 LAB SCIENTIST / LAB TECHNICIAN

**Can Perform:**
- ✅ View lab test requests from doctors
- ✅ Generate invoices for lab tests
- ✅ Perform lab tests
- ✅ Enter lab test results
- ✅ Write lab reports (Laboratory Results, Test Analysis, Specimen Collection, etc.)
- ✅ Manage lab test catalog

**Can View (Read-Only):**
- 👁️ Doctor test requests (to fulfill)
- 👁️ Patient information
- 👁️ Doctor reports
- 👁️ Nursing reports
- 👁️ Pharmacist reports
- 👁️ Payment status (to verify before releasing results)

**Cannot Do:**
- ❌ Request lab tests (Doctor role)
- ❌ Write prescriptions (Doctor role)
- ❌ Dispense medications (Pharmacist role)
- ❌ Modify test requests from doctors
- ❌ Edit/delete reports from other roles

**Modules Access:**
- Laboratory (view catalog)
- Lab Requests (write - perform tests & enter results)
- Patient Reports (write own, view others)
- Billing (view payment status)

---

### 5. 💰 ACCOUNTANT

**Can Perform:**
- ✅ View all invoices (pharmacy, lab, restaurant, etc.)
- ✅ Process payments
- ✅ Mark invoices as paid
- ✅ Print receipts
- ✅ Generate financial reports
- ✅ View billing history

**Can View (Read-Only):**
- 👁️ All invoices from all departments
- 👁️ Patient payment history
- 👁️ Revenue reports

**Cannot Do:**
- ❌ Write prescriptions (Doctor role)
- ❌ Dispense medications (Pharmacist role)
- ❌ Perform lab tests (Lab staff role)
- ❌ Modify invoices (auto-generated by other modules)
- ❌ Write patient reports (clinical staff only)

**Modules Access:**
- Accounting (write - process payments)
- Billing (view all, update payment status)
- Receipt Printing (write)
- Financial Reports (view)

---

### 6. 👨‍🍳 COOK

**Can Perform:**
- ✅ View restaurant menu
- ✅ Create meal orders for patients
- ✅ Generate invoices for meals
- ✅ Manage restaurant orders

**Can View (Read-Only):**
- 👁️ Patient information (for meal orders)
- 👁️ Payment status for meal orders

**Cannot Do:**
- ❌ Process payments (Accountant role)
- ❌ Write patient reports
- ❌ Access clinical modules

**Modules Access:**
- Restaurant (write)
- Restaurant Orders (write)
- Patients (view - for ordering)

---

### 7. 🏥 HOSPITAL ADMIN

**Can Perform:**
- ✅ **Full access to all modules** (view and edit)
- ✅ Manage users (create, edit, delete)
- ✅ Configure hospital settings
- ✅ View all reports and analytics
- ✅ Access all patient records
- ✅ Override restrictions when necessary
- ✅ Manage doctors, departments, inventory

**Special Permissions:**
- 🔓 Can view and edit all staff work
- 🔓 Can manage all system configurations
- 🔓 Can access all modules without restrictions

**Modules Access:**
- All modules (full access)

---

### 8. 🔐 SUPER ADMIN

**Can Perform:**
- ✅ **System-wide access** across all hospitals/tenants
- ✅ Create and manage hospitals
- ✅ Manage users across all hospitals
- ✅ View system-wide analytics
- ✅ Configure system settings
- ✅ Database management

**Special Permissions:**
- 🔓 Full access to all hospitals
- 🔓 Can switch between tenants
- 🔓 System configuration access

**Modules Access:**
- Super Admin Dashboard
- All Hospitals Management
- All Users Management
- System Reports

---

## Patient Reports - Permission Breakdown

### Who Can Write Reports:
1. **Nurse** - Nursing assessments, vital signs, care plans
2. **Doctor** - Clinical assessments, diagnoses, treatment plans
3. **Pharmacist** - Medication management, drug counseling
4. **Pharmacy Technician** - Drug dispensing, patient education
5. **Lab Scientist** - Lab results, test analysis
6. **Lab Technician** - Test results, specimen handling

### Report Separation:

#### 📝 My Reports Section
- **Your own reports** that you have written
- Full visibility into your contributions
- Track your own patient care activities
- Color-coded by your role

#### 👥 Team Reports Section (View Only)
- **Reports from other healthcare staff**
- **Read-only access** - cannot edit or delete
- Ensures collaborative patient care
- Color-coded by writer's role:
  - Yellow: Doctor reports
  - Blue: Nurse reports
  - Green: Pharmacist/Pharmacy Tech reports
  - Pink: Lab Scientist/Lab Tech reports
- Shows "VIEW ONLY" badge
- Displays writer name and role

---

## Module-Specific Permissions

### Consultation Module
- **Can Access:** Doctor, Hospital Admin
- **Write:** Only Doctors
- **View:** Nurses can view in patient records

### Pharmacy Prescriptions
- **Can Access:** Pharmacist, Pharmacy Technician, Hospital Admin
- **Write:** Pharmacists dispense drugs
- **View:** Doctors can view dispensing status

### Lab Requests
- **Can Access:** Lab Scientist, Lab Technician, Hospital Admin
- **Write:** Lab staff perform tests and enter results
- **View:** Doctors can view test results

### Patient Reports
- **Can Access:** Nurse, Doctor, Pharmacist, Pharmacy Technician, Lab Scientist, Lab Technician, Hospital Admin
- **Write:** Own reports only
- **View:** All team reports (read-only)

### Accounting/Billing
- **Can Access:** Accountant, Hospital Admin
- **Write:** Accountants process payments
- **View:** All staff can view payment status for their module

### Nurse Station
- **Can Access:** Nurse, Doctor, Hospital Admin
- **Write:** Nurses record vital signs
- **View:** Doctors can view vital signs

---

## Security Features

### 1. Role Verification
- Every page checks user role before allowing access
- Unauthorized access redirects to dashboard
- Session-based authentication

### 2. Data Isolation
- Users can only see data for their hospital (tenant)
- Multi-tenant architecture ensures complete data separation
- Super Admin can access all tenants

### 3. Action Logging
- All reports track who created them (user ID, role, name)
- Timestamps for all actions
- Audit trail for accountability

### 4. Read-Only Enforcement
- Other staff's reports displayed with "VIEW ONLY" badge
- No edit or delete buttons on other staff's work
- Visual distinction between own work and team work

---

## Permission Matrix

| Role | Consultation | Prescriptions | Pharmacy | Lab Tests | Lab Results | Patient Reports | Billing | Settings |
|------|-------------|---------------|----------|-----------|-------------|-----------------|---------|----------|
| Doctor | ✅ Write | ✅ Write | 👁️ View | ✅ Write | 👁️ View | ✅ Own / 👁️ Team | 👁️ View | ❌ |
| Nurse | 👁️ View | 👁️ View | 👁️ View | 👁️ View | 👁️ View | ✅ Own / 👁️ Team | 👁️ View | ❌ |
| Pharmacist | 👁️ View | 👁️ View | ✅ Write | 👁️ View | 👁️ View | ✅ Own / 👁️ Team | 👁️ View | ❌ |
| Pharmacy Tech | 👁️ View | 👁️ View | ✅ Write | 👁️ View | 👁️ View | ✅ Own / 👁️ Team | 👁️ View | ❌ |
| Lab Scientist | 👁️ View | 👁️ View | 👁️ View | 👁️ View | ✅ Write | ✅ Own / 👁️ Team | 👁️ View | ❌ |
| Lab Technician | 👁️ View | 👁️ View | 👁️ View | 👁️ View | ✅ Write | ✅ Own / 👁️ Team | 👁️ View | ❌ |
| Accountant | 👁️ View | 👁️ View | 👁️ View | 👁️ View | 👁️ View | ❌ | ✅ Write | ❌ |
| Cook | ❌ | ❌ | ❌ | ❌ | ❌ | ❌ | 👁️ View | ❌ |
| Hospital Admin | ✅ Write | ✅ Write | ✅ Write | ✅ Write | ✅ Write | ✅ All | ✅ Write | ✅ Write |
| Super Admin | 🔓 All | 🔓 All | 🔓 All | 🔓 All | 🔓 All | 🔓 All | 🔓 All | 🔓 All |

**Legend:**
- ✅ **Write** - Full create/edit access
- 👁️ **View** - Read-only access
- ❌ **None** - No access
- 🔓 **All** - Unrestricted access

---

## Best Practices

### For Staff Members:
1. **Only perform tasks within your role** - Respect role boundaries
2. **View other staff's work for context** - Use team reports to understand patient care
3. **Don't attempt to modify other's work** - Maintain data integrity
4. **Report any permission issues** - Contact hospital admin

### For Hospital Admins:
1. **Assign correct roles** - Ensure staff have appropriate permissions
2. **Monitor access logs** - Track who accesses what
3. **Train staff on permissions** - Ensure everyone understands their role
4. **Review reports regularly** - Ensure collaborative care is working

### For Security:
1. **Change default passwords** - Security alert shown on first login
2. **Use strong passwords** - System enforces password hashing
3. **Don't share credentials** - Each staff member should have their own account
4. **Log out when done** - Prevent unauthorized access

---

## Troubleshooting

### "Access Denied" Error
- Check your role assignment
- Contact hospital admin to verify permissions
- Ensure you're logged in correctly

### Can't Edit a Report
- Check if it's your own report in "My Reports" section
- Team reports are read-only by design
- Only original author can edit (future feature)

### Module Not Showing in Menu
- Module may not be available for your role
- Check permission matrix above
- Contact hospital admin if you need access

---

**Version:** 2.3.0
**Last Updated:** 2026-02-02
**Security Level:** Role-Based Access Control (RBAC)
