# Hospital Management System - Complete Guide

## System Overview

A comprehensive multi-tenant hospital management system with three-tier user hierarchy: Super Admin, Hospital Admin, and Hospital Staff.

## User Hierarchy

### 1. Super Administrator
**Access Level:** System-wide access to all hospitals

**Credentials:**
- Username: `superadmin`
- Password: `superadmin123`

**Capabilities:**
- View and manage all registered hospitals
- Approve/reject hospital registrations
- Create Hospital Admin accounts
- View all users across all hospitals
- Access system-wide reports and analytics
- Suspend or activate hospitals

### 2. Hospital Administrator
**Access Level:** Full access to their hospital only

**Demo Credentials:**
- Username: `admin`
- Password: `admin123`
- Hospital: City General Hospital

**Capabilities:**
- Create and manage ALL hospital users
- Manage all hospital modules and data
- Cannot access other hospitals' data
- Full CRUD operations within their hospital

### 3. Hospital Staff
**Access Level:** Role-based access to their hospital

**Available Roles:**
- Doctor
- Nurse
- Lab Scientist
- Lab Technician
- Pharmacist
- Pharmacy Technician
- Accountant
- Record Manager
- Receptionist
- Cook
- Cleaner
- Administrative Staff

## System Features

### Core Modules

#### 1. **Patient Management**
- Patient registration with unique patient numbers
- Complete medical history
- Emergency contact information
- Patient search and filtering

#### 2. **Doctor Management**
- Doctor profiles with specializations
- Qualification tracking
- Consultation fees
- Linked to user accounts

#### 3. **Appointment Scheduling**
- Book appointments with doctors
- Status tracking (scheduled, completed, cancelled)
- View today's appointments
- Appointment history

#### 4. **Billing & Invoicing**
- Automatic invoice generation
- Payment tracking
- Multiple payment methods
- Revenue statistics

#### 5. **Patient Admissions**
- Admission management
- Room and bed assignment
- Admission/discharge tracking
- Cost calculation

#### 6. **Pharmacy Module**
- Drug inventory management
- Stock tracking with reorder levels
- Expiry date monitoring
- Dispensing records
- Low stock alerts

#### 7. **Laboratory Module**
- Lab test catalog
- Test orders and results
- Sample tracking
- Payment integration

#### 8. **Restaurant/Catering**
- Menu management
- Meal orders for patients
- Room-wise delivery
- Order tracking

#### 9. **Accounting**
- Income and expense tracking
- Transaction management
- Financial reports
- Net balance calculation

#### 10. **Attendance Register**
- Staff check-in/check-out
- Daily attendance tracking
- Working hours calculation
- Attendance reports

### Multi-Tenant Features

#### Hospital Registration
- Public registration form at `/register_hospital`
- Requires hospital license number
- Subdomain-based identification
- Pending approval workflow

#### Tenant Isolation
- Complete data separation
- Hospital-specific databases
- No cross-hospital data access
- Tenant switching for Super Admin

## Access URLs

### Public Pages
- **Home Page:** `index.php?action=home`
- **Hospital Registration:** `index.php?action=register_hospital`
- **Regular Login:** `index.php?action=login`
- **Super Admin Login:** `index.php?action=super_login`

### Super Admin Pages
- **Dashboard:** `index.php?action=super_admin_dashboard`
- **Hospitals:** `index.php?action=super_admin_hospitals`
- **All Users:** `index.php?action=super_admin_users`
- **Reports:** `index.php?action=super_admin_reports`

### Hospital Admin/Staff Pages
- **Dashboard:** `index.php?action=dashboard`
- **User Management:** `index.php?action=users`
- **Patients:** `index.php?action=patients`
- **Doctors:** `index.php?action=doctors`
- **Appointments:** `index.php?action=appointments`
- **Billing:** `index.php?action=billing`
- **Admissions:** `index.php?action=admissions`
- **Pharmacy:** `index.php?action=pharmacy`
- **Laboratory:** `index.php?action=laboratory`
- **Restaurant:** `index.php?action=restaurant`
- **Accounting:** `index.php?action=accounting`
- **Attendance:** `index.php?action=attendance`

## Database Schema

### Main Tables

1. **tenants** - Hospital information
2. **users** - All system users with roles
3. **patients** - Patient records
4. **doctors** - Doctor profiles
5. **appointments** - Appointment scheduling
6. **billing** - Invoices and payments
7. **admissions** - Patient admissions
8. **pharmacy_inventory** - Drug stock
9. **pharmacy_dispensing** - Drug dispensing records
10. **lab_tests** - Laboratory test catalog
11. **lab_orders** - Lab test orders
12. **restaurant_menu** - Food menu items
13. **restaurant_orders** - Meal orders
14. **attendance** - Staff attendance
15. **accounting_transactions** - Financial transactions
16. **medical_records** - Patient medical history

## User Management Workflow

### For Super Admin:
1. Login to Super Admin portal
2. Navigate to Hospitals section
3. Approve pending hospital registrations
4. System automatically creates Hospital Admin account
5. Credentials are displayed (must be noted)

### For Hospital Admin:
1. Login with provided credentials
2. Navigate to Users section
3. Click "Add New User"
4. Fill in user details:
   - Username (unique)
   - Password
   - Full name
   - Email and phone
   - Role (select from 14 available roles)
   - Department/Specialization
5. System generates employee number automatically
6. For doctors, additional consultation fee can be set
7. User can now login and access relevant modules

### Password Management:
- Hospital Admin can reset user passwords
- New random password is generated
- Must be communicated to user securely

## Hospital Registration Workflow

1. **Hospital Applies:**
   - Visit registration page
   - Fill hospital details
   - Choose unique subdomain
   - Provide license number
   - Submit application

2. **Super Admin Reviews:**
   - Receives notification of new application
   - Reviews hospital credentials
   - Approves or rejects

3. **Approval Process:**
   - Status changes to "active"
   - Hospital Admin account auto-created
   - Username: `{subdomain}_admin`
   - Random secure password generated
   - Credentials displayed to Super Admin

4. **Hospital Admin Setup:**
   - Receives login credentials
   - First login to system
   - Creates department users
   - Configures hospital settings

## Security Features

### Authentication
- Password hashing with PHP password_hash()
- Session management with timeouts
- Role-based access control

### Data Security
- SQL injection prevention (prepared statements)
- XSS protection (output escaping)
- CSRF protection ready
- Tenant data isolation

### User Security
- Unique usernames system-wide
- Strong password requirements
- Account status management
- Activity tracking

## Sample Data

The system comes with pre-populated demo data:

### Demo Hospital: City General Hospital
- Subdomain: demo
- Status: Active

### Demo Users:
1. **Hospital Admin**
   - Username: admin
   - Password: admin123

2. **Doctor**
   - Username: doctor1
   - Password: doctor123
   - Dr. Sarah Johnson (Cardiology)

3. **Pharmacist**
   - Username: pharmacist1
   - Password: pharm123

### Demo Data Includes:
- 1 Sample patient
- 2 Sample doctors
- 3 Lab tests
- 3 Pharmacy items
- 3 Menu items

## Technical Requirements

- PHP 8.4 or higher
- PDO SQLite extension enabled
- Apache/Nginx web server
- Modern web browser
- Minimum 50MB disk space

## File Structure

```
public_html/
├── index.php                      # Main application router
├── config.php                     # Database and configuration
├── hospital_system.db             # SQLite database (auto-created)
├── pages/
│   ├── home.php                   # Landing page
│   ├── login.php                  # Regular login
│   ├── super_login.php            # Super admin login
│   ├── register_hospital.php     # Hospital registration
│   ├── dashboard.php              # Hospital dashboard
│   ├── users.php                  # User management
│   ├── patients.php               # Patient management
│   ├── doctors.php                # Doctor management
│   ├── appointments.php           # Appointments
│   ├── billing.php                # Billing
│   ├── admissions.php             # Patient admissions
│   ├── pharmacy.php               # Pharmacy module
│   ├── laboratory.php             # Lab module
│   ├── restaurant.php             # Restaurant module
│   ├── accounting.php             # Accounting module
│   ├── attendance.php             # Attendance register
│   ├── super_admin_dashboard.php # Super admin dashboard
│   ├── super_admin_hospitals.php # Hospital management
│   ├── super_admin_users.php     # All users view
│   └── super_admin_reports.php   # System reports
├── README.md                      # Basic documentation
└── SYSTEM_GUIDE.md               # This comprehensive guide
```

## Responsive Design

The system is fully responsive with breakpoints:
- **Mobile:** < 480px
- **Tablet:** 480px - 768px
- **Desktop:** > 768px

All tables, forms, and layouts adapt to screen size.

## Future Enhancements

Potential additions:
- PDF report generation
- Email notifications
- SMS integration
- Online appointment booking
- Patient portal
- Mobile app
- Advanced analytics
- Backup and restore
- API integration

## Support

For technical issues or questions:
1. Check this documentation
2. Review inline code comments
3. Contact system administrator

## Version

Version: 2.0.0
Date: January 2026
Built with: PHP 8.4, SQLite, Modern CSS

---

**Important Notes:**
- Always backup database before major updates
- Change default passwords after first login
- Regularly monitor system logs
- Keep PHP version updated
- Test new features in staging environment

