<?php
$db = Database::getInstance()->getConnection();
$tenantId = $_SESSION['tenant_id'];

// Get transactions
$transactions = $db->query("
    SELECT at.*, u.full_name as created_by_name
    FROM accounting_transactions at
    LEFT JOIN users u ON at.created_by = u.id
    WHERE at.tenant_id = $tenantId
    ORDER BY at.transaction_date DESC, at.created_at DESC
")->fetchAll(PDO::FETCH_ASSOC);

// Statistics
$totalIncome = $db->query("SELECT SUM(amount) FROM accounting_transactions WHERE tenant_id = $tenantId AND transaction_type = 'income'")->fetchColumn() ?? 0;
$totalExpense = $db->query("SELECT SUM(amount) FROM accounting_transactions WHERE tenant_id = $tenantId AND transaction_type = 'expense'")->fetchColumn() ?? 0;
$netBalance = $totalIncome - $totalExpense;
?>

<div class="hero">
    <h1>Accounting Management</h1>
    <p>Track financial transactions and reports</p>
</div>

<div class="stats">
    <div class="stat-card success">
        <div class="stat-value"><?= formatCurrency($totalIncome) ?></div>
        <div class="stat-label">Total Income</div>
    </div>
    <div class="stat-card danger">
        <div class="stat-value"><?= formatCurrency($totalExpense) ?></div>
        <div class="stat-label">Total Expenses</div>
    </div>
    <div class="stat-card <?= $netBalance >= 0 ? 'success' : 'danger' ?>">
        <div class="stat-value"><?= formatCurrency($netBalance) ?></div>
        <div class="stat-label">Net Balance</div>
    </div>
    <div class="stat-card">
        <div class="stat-value"><?= count($transactions) ?></div>
        <div class="stat-label">Total Transactions</div>
    </div>
</div>

<div class="card">
    <h2>All Transactions</h2>
    <div style="overflow-x: auto;">
        <table class="table">
            <thead>
                <tr>
                    <th>Transaction #</th>
                    <th>Date</th>
                    <th>Type</th>
                    <th>Category</th>
                    <th>Description</th>
                    <th>Amount</th>
                    <th>Payment Method</th>
                    <th>Created By</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($transactions as $transaction): ?>
                    <tr>
                        <td><strong><?= e($transaction['transaction_number']) ?></strong></td>
                        <td><?= e(date('M j, Y', strtotime($transaction['transaction_date']))) ?></td>
                        <td>
                            <span style="padding: 0.25rem 0.75rem; border-radius: 4px; font-size: 0.875rem;
                                background-color: <?= $transaction['transaction_type'] === 'income' ? '#d1fae5' : '#fee2e2' ?>;
                                color: <?= $transaction['transaction_type'] === 'income' ? '#065f46' : '#991b1b' ?>;">
                                <?= e(ucfirst($transaction['transaction_type'])) ?>
                            </span>
                        </td>
                        <td><?= e($transaction['category'] ?? 'General') ?></td>
                        <td><?= e(substr($transaction['description'], 0, 50)) ?><?= strlen($transaction['description']) > 50 ? '...' : '' ?></td>
                        <td style="font-weight: bold; color: <?= $transaction['transaction_type'] === 'income' ? 'var(--success-color)' : 'var(--danger-color)' ?>;">
                            <?= $transaction['transaction_type'] === 'income' ? '+' : '-' ?><?= formatCurrency($transaction['amount']) ?>
                        </td>
                        <td><?= e($transaction['payment_method'] ?? 'N/A') ?></td>
                        <td><?= e($transaction['created_by_name'] ?? 'System') ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
