<div class="hero" style="background: linear-gradient(135deg, #10b981 0%, #065f46 100%);">
    <h1>Hospital Admin Login - <?= e($currentTenant['name']) ?></h1>
    <p>Access the administrative dashboard to manage hospital settings and users</p>
</div>

<div class="card" style="max-width: 600px; margin: 2rem auto;">
    <div style="text-align: center; margin-bottom: 2rem;">
        <div style="width: 80px; height: 80px; background: #10b981; color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 1rem; font-size: 2rem; font-weight: bold;">A</div>
        <h2 style="color: #065f46;">Hospital Administrator</h2>
        <p style="color: var(--text-light);">For hospital administrators who manage settings, users, and overall operations</p>
    </div>

    <?php if (isset($error)): ?>
        <div class="alert alert-error"><?= e($error) ?></div>
    <?php endif; ?>

    <?php if (!$currentTenant || !isset($currentTenant['id'])): ?>
        <div class="alert alert-error">Error: No hospital selected. Please go back to home page.</div>
    <?php else: ?>
    <form method="POST" action="./index.php?action=admin_login">
        <input type="hidden" name="tenant_id" value="<?= e($currentTenant['id']) ?>">
        <input type="hidden" name="tenant_name" value="<?= e($currentTenant['name']) ?>">

        <div class="form-group">
            <label for="username">Admin Username</label>
            <input type="text" id="username" name="username" class="form-control" placeholder="Enter admin username" required autofocus>
        </div>

        <div class="form-group">
            <label for="password">Admin Password</label>
            <input type="password" id="password" name="password" class="form-control" placeholder="Enter admin password" required>
        </div>

        <button type="submit" name="login" class="btn btn-primary btn-block" style="background: #10b981; font-size: 1.1rem; padding: 1rem;">Login to Admin Dashboard</button>
    </form>

    <div style="margin-top: 2rem; padding: 1.5rem; background: #d1fae5; border-radius: 8px; border-left: 4px solid #10b981;">
        <h3 style="margin-bottom: 1rem; color: #065f46;">Demo Admin Credentials:</h3>
        <div style="background: white; padding: 1rem; border-radius: 6px;">
            <strong>Username:</strong> <code style="background: #f3f4f6; padding: 4px 8px; border-radius: 4px;">admin</code><br>
            <strong>Password:</strong> <code style="background: #f3f4f6; padding: 4px 8px; border-radius: 4px;">admin123</code>
        </div>
        <p style="margin-top: 1rem; font-size: 0.9rem; color: #065f46;">
            Hospital administrators have full access to manage users, settings, reports, and all hospital operations.
        </p>
    </div>

    <div style="margin-top: 1.5rem; text-align: center; padding-top: 1rem; border-top: 1px solid var(--border-color);">
        <p style="color: var(--text-light); margin-bottom: 0.5rem;">Wrong login type?</p>
        <a href="?action=home" style="color: #10b981; text-decoration: none;">Back to Login Selection</a>
    </div>
    <?php endif; ?>
</div>
