<?php
$db = Database::getInstance()->getConnection();
$tenantId = $_SESSION['tenant_id'];

// Get all admissions
$admissions = $db->query("
    SELECT a.*, p.full_name as patient_name, p.patient_number, d.full_name as doctor_name
    FROM admissions a
    JOIN patients p ON a.patient_id = p.id
    JOIN doctors d ON a.doctor_id = d.id
    WHERE a.tenant_id = $tenantId
    ORDER BY a.admission_date DESC
")->fetchAll(PDO::FETCH_ASSOC);

// Statistics
$stats = [
    'total' => count($admissions),
    'admitted' => $db->query("SELECT COUNT(*) FROM admissions WHERE tenant_id = $tenantId AND status = 'admitted'")->fetchColumn(),
    'discharged' => $db->query("SELECT COUNT(*) FROM admissions WHERE tenant_id = $tenantId AND status = 'discharged'")->fetchColumn(),
];
?>

<div class="hero">
    <h1>Patient Admissions</h1>
    <p>Manage patient admissions and ward assignments</p>
</div>

<div class="stats">
    <div class="stat-card">
        <div class="stat-value"><?= $stats['total'] ?></div>
        <div class="stat-label">Total Admissions</div>
    </div>
    <div class="stat-card warning">
        <div class="stat-value"><?= $stats['admitted'] ?></div>
        <div class="stat-label">Currently Admitted</div>
    </div>
    <div class="stat-card success">
        <div class="stat-value"><?= $stats['discharged'] ?></div>
        <div class="stat-label">Discharged</div>
    </div>
</div>

<div class="card">
    <h2>All Admissions</h2>
    <div style="overflow-x: auto;">
        <table class="table">
            <thead>
                <tr>
                    <th>Admission #</th>
                    <th>Patient</th>
                    <th>Doctor</th>
                    <th>Room/Bed</th>
                    <th>Admission Date</th>
                    <th>Discharge Date</th>
                    <th>Status</th>
                    <th>Total Cost</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($admissions as $admission): ?>
                    <tr>
                        <td><strong><?= e($admission['admission_number']) ?></strong></td>
                        <td><?= e($admission['patient_name']) ?><br><small><?= e($admission['patient_number']) ?></small></td>
                        <td><?= e($admission['doctor_name']) ?></td>
                        <td><?= e($admission['room_number'] ?? 'N/A') ?> / <?= e($admission['bed_number'] ?? 'N/A') ?></td>
                        <td><?= e(date('M j, Y', strtotime($admission['admission_date']))) ?></td>
                        <td><?= $admission['discharge_date'] ? e(date('M j, Y', strtotime($admission['discharge_date']))) : '-' ?></td>
                        <td>
                            <span style="padding: 0.25rem 0.75rem; border-radius: 4px; font-size: 0.875rem;
                                background-color: <?= $admission['status'] === 'discharged' ? '#d1fae5' : '#fef3c7' ?>;
                                color: <?= $admission['status'] === 'discharged' ? '#065f46' : '#92400e' ?>;">
                                <?= e(ucfirst($admission['status'])) ?>
                            </span>
                        </td>
                        <td><?= formatCurrency($admission['total_cost']) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
