<?php
$db = Database::getInstance()->getConnection();
$tenantId = $_SESSION['tenant_id'];
$subAction = $_GET['sub'] ?? 'list';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_appointment'])) {
        $stmt = $db->prepare("
            INSERT INTO appointments (tenant_id, patient_id, doctor_id, appointment_date, appointment_time, reason, status)
            VALUES (?, ?, ?, ?, ?, ?, 'scheduled')
        ");

        $stmt->execute([
            $tenantId,
            $_POST['patient_id'],
            $_POST['doctor_id'],
            $_POST['appointment_date'],
            $_POST['appointment_time'],
            $_POST['reason']
        ]);

        $message = 'Appointment scheduled successfully!';
        $subAction = 'list';
    } elseif (isset($_POST['update_status'])) {
        $stmt = $db->prepare("UPDATE appointments SET status = ?, notes = ? WHERE id = ? AND tenant_id = ?");
        $stmt->execute([$_POST['status'], $_POST['notes'], $_POST['appointment_id'], $tenantId]);

        $message = 'Appointment status updated!';
    }
}

// Get appointment for editing
$editAppointment = null;
if ($subAction === 'edit' && isset($_GET['id'])) {
    $stmt = $db->prepare("SELECT * FROM appointments WHERE id = ? AND tenant_id = ?");
    $stmt->execute([$_GET['id'], $tenantId]);
    $editAppointment = $stmt->fetch(PDO::FETCH_ASSOC);
}

// Get all appointments with patient and doctor info
$appointments = $db->query("
    SELECT a.*, p.full_name as patient_name, p.patient_number, d.full_name as doctor_name, d.specialization
    FROM appointments a
    JOIN patients p ON a.patient_id = p.id
    JOIN doctors d ON a.doctor_id = d.id
    WHERE a.tenant_id = $tenantId
    ORDER BY a.appointment_date DESC, a.appointment_time DESC
")->fetchAll(PDO::FETCH_ASSOC);

// Get patients and doctors for dropdowns
$patients = $db->query("SELECT id, patient_number, full_name FROM patients WHERE tenant_id = $tenantId AND status = 'active' ORDER BY full_name")->fetchAll(PDO::FETCH_ASSOC);
$doctors = $db->query("SELECT id, doctor_number, full_name, specialization FROM doctors WHERE tenant_id = $tenantId AND status = 'active' ORDER BY full_name")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="hero">
    <h1>Appointment Management</h1>
    <p>Schedule and manage patient appointments</p>
</div>

<?php if (isset($message)): ?>
    <div class="alert alert-success"><?= e($message) ?></div>
<?php endif; ?>

<?php if ($subAction === 'add'): ?>
    <!-- Add Appointment Form -->
    <div class="card">
        <h2>Schedule New Appointment</h2>
        <form method="POST" action="?action=appointments">
            <div class="grid">
                <div class="form-group">
                    <label for="patient_id">Patient *</label>
                    <select id="patient_id" name="patient_id" class="form-control" required>
                        <option value="">Select Patient</option>
                        <?php foreach ($patients as $patient): ?>
                            <option value="<?= $patient['id'] ?>">
                                <?= e($patient['patient_number']) ?> - <?= e($patient['full_name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="doctor_id">Doctor *</label>
                    <select id="doctor_id" name="doctor_id" class="form-control" required>
                        <option value="">Select Doctor</option>
                        <?php foreach ($doctors as $doctor): ?>
                            <option value="<?= $doctor['id'] ?>">
                                <?= e($doctor['full_name']) ?> - <?= e($doctor['specialization']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="appointment_date">Appointment Date *</label>
                    <input type="date" id="appointment_date" name="appointment_date" class="form-control"
                           min="<?= date('Y-m-d') ?>" required>
                </div>

                <div class="form-group">
                    <label for="appointment_time">Appointment Time *</label>
                    <input type="time" id="appointment_time" name="appointment_time" class="form-control" required>
                </div>
            </div>

            <div class="form-group">
                <label for="reason">Reason for Visit</label>
                <textarea id="reason" name="reason" class="form-control" rows="3"
                          placeholder="Describe the reason for this appointment"></textarea>
            </div>

            <div style="display: flex; gap: 1rem;">
                <button type="submit" name="add_appointment" class="btn btn-primary">Schedule Appointment</button>
                <a href="?action=appointments" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
<?php elseif ($subAction === 'edit' && $editAppointment): ?>
    <!-- Edit Appointment Status -->
    <div class="card">
        <h2>Update Appointment Status</h2>
        <form method="POST" action="?action=appointments&sub=edit&id=<?= $editAppointment['id'] ?>">
            <input type="hidden" name="appointment_id" value="<?= $editAppointment['id'] ?>">

            <div class="form-group">
                <label>Appointment Details</label>
                <div style="padding: 1rem; background: var(--light-color); border-radius: 6px; line-height: 1.8;">
                    <p><strong>Date:</strong> <?= e(date('F j, Y', strtotime($editAppointment['appointment_date']))) ?></p>
                    <p><strong>Time:</strong> <?= e(date('g:i A', strtotime($editAppointment['appointment_time']))) ?></p>
                </div>
            </div>

            <div class="form-group">
                <label for="status">Status *</label>
                <select id="status" name="status" class="form-control" required>
                    <option value="scheduled" <?= $editAppointment['status'] === 'scheduled' ? 'selected' : '' ?>>Scheduled</option>
                    <option value="completed" <?= $editAppointment['status'] === 'completed' ? 'selected' : '' ?>>Completed</option>
                    <option value="cancelled" <?= $editAppointment['status'] === 'cancelled' ? 'selected' : '' ?>>Cancelled</option>
                </select>
            </div>

            <div class="form-group">
                <label for="notes">Notes</label>
                <textarea id="notes" name="notes" class="form-control" rows="4"><?= e($editAppointment['notes'] ?? '') ?></textarea>
            </div>

            <div style="display: flex; gap: 1rem;">
                <button type="submit" name="update_status" class="btn btn-primary">Update Appointment</button>
                <a href="?action=appointments" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
<?php else: ?>
    <!-- Appointment List -->
    <div class="card">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem; flex-wrap: wrap; gap: 1rem;">
            <h2>All Appointments (<?= count($appointments) ?>)</h2>
            <a href="?action=appointments&sub=add" class="btn btn-primary">+ Schedule Appointment</a>
        </div>

        <?php if (count($appointments) > 0): ?>
            <div style="overflow-x: auto;">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Time</th>
                            <th>Patient</th>
                            <th>Doctor</th>
                            <th>Specialization</th>
                            <th>Reason</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($appointments as $apt): ?>
                            <tr>
                                <td><?= e(date('M j, Y', strtotime($apt['appointment_date']))) ?></td>
                                <td><?= e(date('g:i A', strtotime($apt['appointment_time']))) ?></td>
                                <td>
                                    <div><?= e($apt['patient_name']) ?></div>
                                    <small style="color: var(--text-light);"><?= e($apt['patient_number']) ?></small>
                                </td>
                                <td><?= e($apt['doctor_name']) ?></td>
                                <td><?= e($apt['specialization']) ?></td>
                                <td><?= e(substr($apt['reason'] ?? 'N/A', 0, 50)) ?><?= strlen($apt['reason'] ?? '') > 50 ? '...' : '' ?></td>
                                <td>
                                    <span style="padding: 0.25rem 0.75rem; border-radius: 4px; font-size: 0.875rem;
                                        background-color: <?= $apt['status'] === 'completed' ? '#d1fae5' : ($apt['status'] === 'cancelled' ? '#fee2e2' : '#fef3c7') ?>;
                                        color: <?= $apt['status'] === 'completed' ? '#065f46' : ($apt['status'] === 'cancelled' ? '#991b1b' : '#92400e') ?>;">
                                        <?= e(ucfirst($apt['status'])) ?>
                                    </span>
                                </td>
                                <td>
                                    <a href="?action=appointments&sub=edit&id=<?= $apt['id'] ?>" class="btn btn-secondary" style="padding: 0.5rem 1rem; font-size: 0.875rem;">Update</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p style="text-align: center; padding: 3rem; color: var(--text-light);">
                No appointments scheduled yet. Click "Schedule Appointment" to get started.
            </p>
        <?php endif; ?>
    </div>
<?php endif; ?>
