<?php
$db = Database::getInstance()->getConnection();
$tenantId = $_SESSION['tenant_id'];

// Get today's attendance
$today = date('Y-m-d');
$todayAttendance = $db->query("
    SELECT a.*, u.full_name, u.employee_number, u.role, u.department
    FROM attendance a
    JOIN users u ON a.user_id = u.id
    WHERE a.tenant_id = $tenantId AND a.attendance_date = '$today'
    ORDER BY a.check_in_time DESC
")->fetchAll(PDO::FETCH_ASSOC);

// Statistics
$stats = [
    'present' => $db->query("SELECT COUNT(*) FROM attendance WHERE tenant_id = $tenantId AND attendance_date = '$today' AND status = 'present'")->fetchColumn(),
    'absent' => $db->query("SELECT COUNT(*) FROM attendance WHERE tenant_id = $tenantId AND attendance_date = '$today' AND status = 'absent'")->fetchColumn(),
    'late' => $db->query("SELECT COUNT(*) FROM attendance WHERE tenant_id = $tenantId AND attendance_date = '$today' AND status = 'late'")->fetchColumn(),
    'total_staff' => $db->query("SELECT COUNT(*) FROM users WHERE tenant_id = $tenantId AND status = 'active'")->fetchColumn(),
];
?>

<div class="hero">
    <h1>Attendance Register</h1>
    <p>Track staff attendance and working hours</p>
    <p style="font-size: 0.95rem; opacity: 0.9;">Today: <?= date('l, F j, Y') ?></p>
</div>

<div class="stats">
    <div class="stat-card">
        <div class="stat-value"><?= $stats['total_staff'] ?></div>
        <div class="stat-label">Total Staff</div>
    </div>
    <div class="stat-card success">
        <div class="stat-value"><?= $stats['present'] ?></div>
        <div class="stat-label">Present Today</div>
    </div>
    <div class="stat-card danger">
        <div class="stat-value"><?= $stats['absent'] ?></div>
        <div class="stat-label">Absent</div>
    </div>
    <div class="stat-card warning">
        <div class="stat-value"><?= $stats['late'] ?></div>
        <div class="stat-label">Late</div>
    </div>
</div>

<div class="card">
    <h2>Today's Attendance (<?= date('M j, Y') ?>)</h2>
    <?php if (count($todayAttendance) > 0): ?>
        <div style="overflow-x: auto;">
            <table class="table">
                <thead>
                    <tr>
                        <th>Employee #</th>
                        <th>Name</th>
                        <th>Role</th>
                        <th>Department</th>
                        <th>Check In</th>
                        <th>Check Out</th>
                        <th>Hours Worked</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($todayAttendance as $record): ?>
                        <?php
                        $hoursWorked = 'N/A';
                        if ($record['check_in_time'] && $record['check_out_time']) {
                            $checkIn = new DateTime($record['check_in_time']);
                            $checkOut = new DateTime($record['check_out_time']);
                            $diff = $checkIn->diff($checkOut);
                            $hoursWorked = $diff->format('%h hrs %i mins');
                        }
                        ?>
                        <tr>
                            <td><strong><?= e($record['employee_number']) ?></strong></td>
                            <td><?= e($record['full_name']) ?></td>
                            <td><?= e(getRoleName($record['role'])) ?></td>
                            <td><?= e($record['department'] ?? 'N/A') ?></td>
                            <td><?= $record['check_in_time'] ? e(date('g:i A', strtotime($record['check_in_time']))) : 'N/A' ?></td>
                            <td><?= $record['check_out_time'] ? e(date('g:i A', strtotime($record['check_out_time']))) : '-' ?></td>
                            <td><?= $hoursWorked ?></td>
                            <td>
                                <span style="padding: 0.25rem 0.75rem; border-radius: 4px; font-size: 0.875rem;
                                    background-color: <?= $record['status'] === 'present' ? '#d1fae5' : ($record['status'] === 'absent' ? '#fee2e2' : '#fef3c7') ?>;
                                    color: <?= $record['status'] === 'present' ? '#065f46' : ($record['status'] === 'absent' ? '#991b1b' : '#92400e') ?>;">
                                    <?= e(ucfirst($record['status'])) ?>
                                </span>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <p style="text-align: center; padding: 3rem; color: var(--text-light);">No attendance records for today yet.</p>
    <?php endif; ?>
</div>
