<?php
$db = Database::getInstance()->getConnection();
$tenantId = $_SESSION['tenant_id'];
$userRole = $_SESSION['role'];
$subAction = $_GET['sub'] ?? 'list';

// Check if user can mark payments
$canMarkPayments = in_array($userRole, ['hospital_admin', 'accountant']);

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_bill'])) {
        $invoiceNumber = 'INV' . date('Ymd') . str_pad($db->query("SELECT COUNT(*) FROM billing WHERE tenant_id = $tenantId")->fetchColumn() + 1, 4, '0', STR_PAD_LEFT);

        $stmt = $db->prepare("
            INSERT INTO billing (tenant_id, patient_id, appointment_id, invoice_number, description, amount, payment_status)
            VALUES (?, ?, ?, ?, ?, ?, 'pending')
        ");

        $appointmentId = $_POST['appointment_id'] ?: null;

        $stmt->execute([
            $tenantId,
            $_POST['patient_id'],
            $appointmentId,
            $invoiceNumber,
            $_POST['description'],
            $_POST['amount']
        ]);

        $message = 'Invoice created successfully!';
        $subAction = 'list';
    } elseif (isset($_POST['update_payment'])) {
        $paymentDate = $_POST['payment_status'] === 'paid' ? date('Y-m-d H:i:s') : null;

        $stmt = $db->prepare("
            UPDATE billing SET
                payment_status = ?,
                payment_method = ?,
                payment_date = ?
            WHERE id = ? AND tenant_id = ?
        ");

        $stmt->execute([
            $_POST['payment_status'],
            $_POST['payment_method'],
            $paymentDate,
            $_POST['bill_id'],
            $tenantId
        ]);

        $message = 'Payment status updated successfully!';
    }
}

// Get bill for editing
$editBill = null;
if ($subAction === 'edit' && isset($_GET['id'])) {
    $stmt = $db->prepare("
        SELECT b.*, p.full_name as patient_name, p.patient_number
        FROM billing b
        JOIN patients p ON b.patient_id = p.id
        WHERE b.id = ? AND b.tenant_id = ?
    ");
    $stmt->execute([$_GET['id'], $tenantId]);
    $editBill = $stmt->fetch(PDO::FETCH_ASSOC);
}

// Get all bills with patient info
$bills = $db->query("
    SELECT b.*, p.full_name as patient_name, p.patient_number
    FROM billing b
    JOIN patients p ON b.patient_id = p.id
    WHERE b.tenant_id = $tenantId
    ORDER BY b.created_at DESC
")->fetchAll(PDO::FETCH_ASSOC);

// Get patients and appointments for dropdowns
$patients = $db->query("SELECT id, patient_number, full_name FROM patients WHERE tenant_id = $tenantId AND status = 'active' ORDER BY full_name")->fetchAll(PDO::FETCH_ASSOC);
$appointments = $db->query("
    SELECT a.id, a.appointment_date, a.appointment_time, p.full_name as patient_name, d.full_name as doctor_name
    FROM appointments a
    JOIN patients p ON a.patient_id = p.id
    JOIN doctors d ON a.doctor_id = d.id
    WHERE a.tenant_id = $tenantId AND a.status = 'completed'
    ORDER BY a.appointment_date DESC
")->fetchAll(PDO::FETCH_ASSOC);

// Calculate statistics
$totalRevenue = $db->query("SELECT SUM(amount) FROM billing WHERE tenant_id = $tenantId AND payment_status = 'paid'")->fetchColumn() ?? 0;
$pendingAmount = $db->query("SELECT SUM(amount) FROM billing WHERE tenant_id = $tenantId AND payment_status = 'pending'")->fetchColumn() ?? 0;
?>

<div class="hero">
    <h1>Billing & Invoicing</h1>
    <p>Manage invoices and payment tracking</p>
</div>

<?php if (isset($message)): ?>
    <div class="alert alert-success"><?= e($message) ?></div>
<?php endif; ?>

<!-- Statistics -->
<div class="stats">
    <div class="stat-card success">
        <div class="stat-value">$<?= number_format($totalRevenue, 2) ?></div>
        <div class="stat-label">Total Revenue (Paid)</div>
    </div>

    <div class="stat-card warning">
        <div class="stat-value">$<?= number_format($pendingAmount, 2) ?></div>
        <div class="stat-label">Pending Payments</div>
    </div>

    <div class="stat-card">
        <div class="stat-value"><?= count($bills) ?></div>
        <div class="stat-label">Total Invoices</div>
    </div>
</div>

<?php if ($subAction === 'add'): ?>
    <!-- Add Bill Form -->
    <div class="card">
        <h2>Create New Invoice</h2>
        <form method="POST" action="?action=billing">
            <div class="grid">
                <div class="form-group">
                    <label for="patient_id">Patient *</label>
                    <select id="patient_id" name="patient_id" class="form-control" required>
                        <option value="">Select Patient</option>
                        <?php foreach ($patients as $patient): ?>
                            <option value="<?= $patient['id'] ?>">
                                <?= e($patient['patient_number']) ?> - <?= e($patient['full_name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="appointment_id">Related Appointment (Optional)</label>
                    <select id="appointment_id" name="appointment_id" class="form-control">
                        <option value="">None</option>
                        <?php foreach ($appointments as $apt): ?>
                            <option value="<?= $apt['id'] ?>">
                                <?= e(date('M j, Y', strtotime($apt['appointment_date']))) ?> -
                                <?= e($apt['patient_name']) ?> with <?= e($apt['doctor_name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>

            <div class="form-group">
                <label for="description">Description *</label>
                <textarea id="description" name="description" class="form-control" rows="3" required
                          placeholder="Describe the services provided"></textarea>
            </div>

            <div class="form-group">
                <label for="amount">Amount ($) *</label>
                <input type="number" id="amount" name="amount" class="form-control"
                       step="0.01" min="0" required>
            </div>

            <div style="display: flex; gap: 1rem;">
                <button type="submit" name="add_bill" class="btn btn-primary">Create Invoice</button>
                <a href="?action=billing" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
<?php elseif ($subAction === 'edit' && $editBill): ?>
    <!-- Edit Payment Status -->
    <div class="card">
        <h2>Update Payment Status</h2>
        <form method="POST" action="?action=billing&sub=edit&id=<?= $editBill['id'] ?>">
            <input type="hidden" name="bill_id" value="<?= $editBill['id'] ?>">

            <div class="form-group">
                <label>Invoice Details</label>
                <div style="padding: 1rem; background: var(--light-color); border-radius: 6px; line-height: 1.8;">
                    <p><strong>Invoice #:</strong> <?= e($editBill['invoice_number']) ?></p>
                    <p><strong>Patient:</strong> <?= e($editBill['patient_name']) ?> (<?= e($editBill['patient_number']) ?>)</p>
                    <p><strong>Amount:</strong> $<?= number_format($editBill['amount'], 2) ?></p>
                    <p><strong>Description:</strong> <?= e($editBill['description']) ?></p>
                </div>
            </div>

            <div class="grid">
                <div class="form-group">
                    <label for="payment_status">Payment Status *</label>
                    <select id="payment_status" name="payment_status" class="form-control" required>
                        <option value="pending" <?= $editBill['payment_status'] === 'pending' ? 'selected' : '' ?>>Pending</option>
                        <option value="paid" <?= $editBill['payment_status'] === 'paid' ? 'selected' : '' ?>>Paid</option>
                        <option value="cancelled" <?= $editBill['payment_status'] === 'cancelled' ? 'selected' : '' ?>>Cancelled</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="payment_method">Payment Method</label>
                    <select id="payment_method" name="payment_method" class="form-control">
                        <option value="">Select Method</option>
                        <option value="Cash" <?= ($editBill['payment_method'] ?? '') === 'Cash' ? 'selected' : '' ?>>Cash</option>
                        <option value="Credit Card" <?= ($editBill['payment_method'] ?? '') === 'Credit Card' ? 'selected' : '' ?>>Credit Card</option>
                        <option value="Debit Card" <?= ($editBill['payment_method'] ?? '') === 'Debit Card' ? 'selected' : '' ?>>Debit Card</option>
                        <option value="Insurance" <?= ($editBill['payment_method'] ?? '') === 'Insurance' ? 'selected' : '' ?>>Insurance</option>
                        <option value="Bank Transfer" <?= ($editBill['payment_method'] ?? '') === 'Bank Transfer' ? 'selected' : '' ?>>Bank Transfer</option>
                    </select>
                </div>
            </div>

            <?php if ($editBill['payment_date']): ?>
                <div class="form-group">
                    <label>Payment Date</label>
                    <div style="padding: 0.75rem; background: var(--light-color); border-radius: 6px;">
                        <?= e(date('F j, Y g:i A', strtotime($editBill['payment_date']))) ?>
                    </div>
                </div>
            <?php endif; ?>

            <div style="display: flex; gap: 1rem;">
                <button type="submit" name="update_payment" class="btn btn-primary">Update Payment</button>
                <a href="?action=billing" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
<?php else: ?>
    <!-- Bill List -->
    <div class="card">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem; flex-wrap: wrap; gap: 1rem;">
            <h2>All Invoices (<?= count($bills) ?>)</h2>
            <a href="?action=billing&sub=add" class="btn btn-primary">+ Create Invoice</a>
        </div>

        <?php if (count($bills) > 0): ?>
            <div style="overflow-x: auto;">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Invoice #</th>
                            <th>Date</th>
                            <th>Patient</th>
                            <th>Description</th>
                            <th>Amount</th>
                            <th>Payment Status</th>
                            <th>Payment Method</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($bills as $bill): ?>
                            <tr>
                                <td><strong><?= e($bill['invoice_number']) ?></strong></td>
                                <td><?= e(date('M j, Y', strtotime($bill['created_at']))) ?></td>
                                <td>
                                    <div><?= e($bill['patient_name']) ?></div>
                                    <small style="color: var(--text-light);"><?= e($bill['patient_number']) ?></small>
                                </td>
                                <td><?= e(substr($bill['description'], 0, 40)) ?><?= strlen($bill['description']) > 40 ? '...' : '' ?></td>
                                <td><strong>$<?= number_format($bill['amount'], 2) ?></strong></td>
                                <td>
                                    <span style="padding: 0.25rem 0.75rem; border-radius: 4px; font-size: 0.875rem;
                                        background-color: <?= $bill['payment_status'] === 'paid' ? '#d1fae5' : ($bill['payment_status'] === 'cancelled' ? '#fee2e2' : '#fef3c7') ?>;
                                        color: <?= $bill['payment_status'] === 'paid' ? '#065f46' : ($bill['payment_status'] === 'cancelled' ? '#991b1b' : '#92400e') ?>;">
                                        <?= e(ucfirst($bill['payment_status'])) ?>
                                    </span>
                                </td>
                                <td><?= e($bill['payment_method'] ?? 'N/A') ?></td>
                                <td>
                                    <div style="display: flex; gap: 0.5rem; flex-wrap: wrap;">
                                        <?php if ($canMarkPayments): ?>
                                            <a href="?action=billing&sub=edit&id=<?= $bill['id'] ?>" class="btn btn-secondary" style="padding: 0.5rem 1rem; font-size: 0.875rem;">Update</a>
                                        <?php endif; ?>
                                        <?php if ($bill['payment_status'] === 'paid'): ?>
                                            <a href="?action=receipt&id=<?= $bill['id'] ?>" target="_blank" class="btn btn-primary" style="padding: 0.5rem 1rem; font-size: 0.875rem;">📄 Receipt</a>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p style="text-align: center; padding: 3rem; color: var(--text-light);">
                No invoices created yet. Click "Create Invoice" to get started.
            </p>
        <?php endif; ?>
    </div>
<?php endif; ?>
