<?php
$db = Database::getInstance()->getConnection();
$tenantId = $_SESSION['tenant_id'];

// Get statistics
$stats = [
    'patients' => $db->query("SELECT COUNT(*) FROM patients WHERE tenant_id = $tenantId AND status = 'active'")->fetchColumn(),
    'doctors' => $db->query("SELECT COUNT(*) FROM doctors WHERE tenant_id = $tenantId AND status = 'active'")->fetchColumn(),
    'appointments_today' => $db->query("SELECT COUNT(*) FROM appointments WHERE tenant_id = $tenantId AND appointment_date = DATE('now')")->fetchColumn(),
    'pending_bills' => $db->query("SELECT COUNT(*) FROM billing WHERE tenant_id = $tenantId AND payment_status = 'pending'")->fetchColumn(),
];

// Get recent appointments
$recentAppointments = $db->query("
    SELECT a.*, p.full_name as patient_name, d.full_name as doctor_name
    FROM appointments a
    JOIN patients p ON a.patient_id = p.id
    JOIN doctors d ON a.doctor_id = d.id
    WHERE a.tenant_id = $tenantId
    ORDER BY a.appointment_date DESC, a.appointment_time DESC
    LIMIT 5
")->fetchAll(PDO::FETCH_ASSOC);

// Get today's appointments
$todayAppointments = $db->query("
    SELECT a.*, p.full_name as patient_name, d.full_name as doctor_name
    FROM appointments a
    JOIN patients p ON a.patient_id = p.id
    JOIN doctors d ON a.doctor_id = d.id
    WHERE a.tenant_id = $tenantId AND a.appointment_date = DATE('now')
    ORDER BY a.appointment_time ASC
")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="hero">
    <h1>Dashboard</h1>
    <p>Welcome back, <?= e($_SESSION['full_name']) ?> (<?= e(ucfirst($_SESSION['role'])) ?>)</p>
</div>

<!-- Statistics -->
<div class="stats">
    <div class="stat-card">
        <div class="stat-value"><?= $stats['patients'] ?></div>
        <div class="stat-label">Total Patients</div>
    </div>

    <div class="stat-card success">
        <div class="stat-value"><?= $stats['doctors'] ?></div>
        <div class="stat-label">Active Doctors</div>
    </div>

    <div class="stat-card warning">
        <div class="stat-value"><?= $stats['appointments_today'] ?></div>
        <div class="stat-label">Today's Appointments</div>
    </div>

    <div class="stat-card danger">
        <div class="stat-value"><?= $stats['pending_bills'] ?></div>
        <div class="stat-label">Pending Bills</div>
    </div>
</div>

<!-- Quick Actions -->
<div class="card">
    <h2>Quick Actions</h2>
    <div class="grid">
        <a href="?action=patients&sub=add" class="feature-card">
            <div class="feature-icon">+</div>
            <h3>Add Patient</h3>
            <p>Register a new patient</p>
        </a>

        <a href="?action=appointments&sub=add" class="feature-card">
            <div class="feature-icon">A</div>
            <h3>New Appointment</h3>
            <p>Schedule an appointment</p>
        </a>

        <a href="?action=billing&sub=add" class="feature-card">
            <div class="feature-icon">B</div>
            <h3>Create Invoice</h3>
            <p>Generate a new bill</p>
        </a>

        <a href="?action=doctors" class="feature-card">
            <div class="feature-icon">D</div>
            <h3>View Doctors</h3>
            <p>Manage doctor profiles</p>
        </a>
    </div>
</div>

<!-- Today's Appointments -->
<div class="card">
    <h2>Today's Appointments (<?= date('F j, Y') ?>)</h2>
    <?php if (count($todayAppointments) > 0): ?>
        <div style="overflow-x: auto;">
            <table class="table">
                <thead>
                    <tr>
                        <th>Time</th>
                        <th>Patient</th>
                        <th>Doctor</th>
                        <th>Reason</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($todayAppointments as $apt): ?>
                        <tr>
                            <td><?= e(date('g:i A', strtotime($apt['appointment_time']))) ?></td>
                            <td><?= e($apt['patient_name']) ?></td>
                            <td><?= e($apt['doctor_name']) ?></td>
                            <td><?= e($apt['reason'] ?? 'N/A') ?></td>
                            <td>
                                <span style="padding: 0.25rem 0.75rem; border-radius: 4px; font-size: 0.875rem;
                                    background-color: <?= $apt['status'] === 'completed' ? '#d1fae5' : ($apt['status'] === 'cancelled' ? '#fee2e2' : '#fef3c7') ?>;
                                    color: <?= $apt['status'] === 'completed' ? '#065f46' : ($apt['status'] === 'cancelled' ? '#991b1b' : '#92400e') ?>;">
                                    <?= e(ucfirst($apt['status'])) ?>
                                </span>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <p style="text-align: center; padding: 2rem; color: var(--text-light);">No appointments scheduled for today</p>
    <?php endif; ?>
</div>

<!-- Recent Appointments -->
<div class="card">
    <h2>Recent Appointments</h2>
    <?php if (count($recentAppointments) > 0): ?>
        <div style="overflow-x: auto;">
            <table class="table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Time</th>
                        <th>Patient</th>
                        <th>Doctor</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($recentAppointments as $apt): ?>
                        <tr>
                            <td><?= e(date('M j, Y', strtotime($apt['appointment_date']))) ?></td>
                            <td><?= e(date('g:i A', strtotime($apt['appointment_time']))) ?></td>
                            <td><?= e($apt['patient_name']) ?></td>
                            <td><?= e($apt['doctor_name']) ?></td>
                            <td>
                                <span style="padding: 0.25rem 0.75rem; border-radius: 4px; font-size: 0.875rem;
                                    background-color: <?= $apt['status'] === 'completed' ? '#d1fae5' : ($apt['status'] === 'cancelled' ? '#fee2e2' : '#fef3c7') ?>;
                                    color: <?= $apt['status'] === 'completed' ? '#065f46' : ($apt['status'] === 'cancelled' ? '#991b1b' : '#92400e') ?>;">
                                    <?= e(ucfirst($apt['status'])) ?>
                                </span>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <p style="text-align: center; padding: 2rem; color: var(--text-light);">No appointments found</p>
    <?php endif; ?>
</div>
