<?php
$db = Database::getInstance()->getConnection();
$tenantId = $_SESSION['tenant_id'];
$userRole = $_SESSION['role'];
$subAction = $_GET['sub'] ?? 'list';

// Check if user can add/edit doctors (only Hospital Admin)
$canManageDoctors = ($userRole === 'hospital_admin');

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_doctor']) && $canManageDoctors) {
        $doctorNumber = 'DOC' . str_pad($db->query("SELECT COUNT(*) FROM doctors WHERE tenant_id = $tenantId")->fetchColumn() + 1, 3, '0', STR_PAD_LEFT);

        $stmt = $db->prepare("
            INSERT INTO doctors (tenant_id, doctor_number, full_name, specialization, qualification, phone, email, consultation_fee)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)
        ");

        $stmt->execute([
            $tenantId,
            $doctorNumber,
            $_POST['full_name'],
            $_POST['specialization'],
            $_POST['qualification'],
            $_POST['phone'],
            $_POST['email'],
            $_POST['consultation_fee']
        ]);

        $message = 'Doctor added successfully!';
        $subAction = 'list';
    } elseif (isset($_POST['update_doctor'])) {
        $stmt = $db->prepare("
            UPDATE doctors SET
                full_name = ?, specialization = ?, qualification = ?,
                phone = ?, email = ?, consultation_fee = ?
            WHERE id = ? AND tenant_id = ?
        ");

        $stmt->execute([
            $_POST['full_name'],
            $_POST['specialization'],
            $_POST['qualification'],
            $_POST['phone'],
            $_POST['email'],
            $_POST['consultation_fee'],
            $_POST['doctor_id'],
            $tenantId
        ]);

        $message = 'Doctor updated successfully!';
        $subAction = 'list';
    }
}

// Get doctor for editing
$editDoctor = null;
if ($subAction === 'edit' && isset($_GET['id'])) {
    $stmt = $db->prepare("SELECT * FROM doctors WHERE id = ? AND tenant_id = ?");
    $stmt->execute([$_GET['id'], $tenantId]);
    $editDoctor = $stmt->fetch(PDO::FETCH_ASSOC);
}

// Get all doctors
$doctors = $db->query("SELECT * FROM doctors WHERE tenant_id = $tenantId ORDER BY full_name")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="hero">
    <h1>Doctor Management</h1>
    <p>Manage doctor profiles and information</p>
</div>

<?php if (isset($message)): ?>
    <div class="alert alert-success"><?= e($message) ?></div>
<?php endif; ?>

<?php if ($subAction === 'add' || $subAction === 'edit'): ?>
    <!-- Add/Edit Doctor Form -->
    <div class="card">
        <h2><?= $subAction === 'edit' ? 'Edit Doctor' : 'Add New Doctor' ?></h2>
        <form method="POST" action="?action=doctors">
            <?php if ($subAction === 'edit'): ?>
                <input type="hidden" name="doctor_id" value="<?= e($editDoctor['id']) ?>">
            <?php endif; ?>

            <div class="grid">
                <div class="form-group">
                    <label for="full_name">Full Name *</label>
                    <input type="text" id="full_name" name="full_name" class="form-control"
                           value="<?= e($editDoctor['full_name'] ?? '') ?>" required>
                </div>

                <div class="form-group">
                    <label for="specialization">Specialization *</label>
                    <input type="text" id="specialization" name="specialization" class="form-control"
                           value="<?= e($editDoctor['specialization'] ?? '') ?>" required
                           placeholder="e.g., Cardiology, Pediatrics">
                </div>

                <div class="form-group">
                    <label for="qualification">Qualification</label>
                    <input type="text" id="qualification" name="qualification" class="form-control"
                           value="<?= e($editDoctor['qualification'] ?? '') ?>"
                           placeholder="e.g., MD, MBBS, PhD">
                </div>

                <div class="form-group">
                    <label for="phone">Phone</label>
                    <input type="tel" id="phone" name="phone" class="form-control"
                           value="<?= e($editDoctor['phone'] ?? '') ?>">
                </div>

                <div class="form-group">
                    <label for="email">Email</label>
                    <input type="email" id="email" name="email" class="form-control"
                           value="<?= e($editDoctor['email'] ?? '') ?>">
                </div>

                <div class="form-group">
                    <label for="consultation_fee">Consultation Fee ($)</label>
                    <input type="number" id="consultation_fee" name="consultation_fee" class="form-control"
                           value="<?= e($editDoctor['consultation_fee'] ?? '') ?>" step="0.01" min="0">
                </div>
            </div>

            <div style="display: flex; gap: 1rem;">
                <button type="submit" name="<?= $subAction === 'edit' ? 'update_doctor' : 'add_doctor' ?>" class="btn btn-primary">
                    <?= $subAction === 'edit' ? 'Update Doctor' : 'Add Doctor' ?>
                </button>
                <a href="?action=doctors" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
<?php else: ?>
    <!-- Doctor List -->
    <div class="card">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem; flex-wrap: wrap; gap: 1rem;">
            <h2>All Doctors (<?= count($doctors) ?>)</h2>
            <?php if ($canManageDoctors): ?>
                <a href="?action=doctors&sub=add" class="btn btn-primary">+ Add New Doctor</a>
            <?php else: ?>
                <span style="color: var(--text-light); font-size: 0.9rem;">(View Only - Contact Admin to add doctors)</span>
            <?php endif; ?>
        </div>

        <?php if (count($doctors) > 0): ?>
            <div class="grid">
                <?php foreach ($doctors as $doctor): ?>
                    <div class="card" style="border-left: 4px solid var(--primary-color);">
                        <div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 1rem;">
                            <div>
                                <h3 style="margin-bottom: 0.25rem;"><?= e($doctor['full_name']) ?></h3>
                                <p style="color: var(--text-light); font-size: 0.875rem;"><?= e($doctor['doctor_number']) ?></p>
                            </div>
                            <a href="?action=doctors&sub=edit&id=<?= $doctor['id'] ?>" class="btn btn-secondary" style="padding: 0.5rem 1rem; font-size: 0.875rem;">Edit</a>
                        </div>

                        <div style="line-height: 1.8; color: var(--text-dark);">
                            <p><strong>Specialization:</strong> <?= e($doctor['specialization']) ?></p>
                            <?php if ($doctor['qualification']): ?>
                                <p><strong>Qualification:</strong> <?= e($doctor['qualification']) ?></p>
                            <?php endif; ?>
                            <?php if ($doctor['phone']): ?>
                                <p><strong>Phone:</strong> <?= e($doctor['phone']) ?></p>
                            <?php endif; ?>
                            <?php if ($doctor['email']): ?>
                                <p><strong>Email:</strong> <?= e($doctor['email']) ?></p>
                            <?php endif; ?>
                            <?php if ($doctor['consultation_fee']): ?>
                                <p><strong>Consultation Fee:</strong> $<?= number_format($doctor['consultation_fee'], 2) ?></p>
                            <?php endif; ?>
                        </div>

                        <div style="margin-top: 1rem; padding-top: 1rem; border-top: 1px solid var(--border-color);">
                            <span style="padding: 0.25rem 0.75rem; border-radius: 4px; font-size: 0.875rem; background-color: #d1fae5; color: #065f46;">
                                <?= e(ucfirst($doctor['status'])) ?>
                            </span>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <p style="text-align: center; padding: 3rem; color: var(--text-light);">
                No doctors registered yet. Click "Add New Doctor" to get started.
            </p>
        <?php endif; ?>
    </div>
<?php endif; ?>
