<!-- Hero Section -->
<div class="hero">
    <h1>Welcome to <?= e($currentTenant['name']) ?></h1>
    <p>Advanced Multi-Tenant Hospital Management System</p>
    <p>Comprehensive healthcare management solution for modern hospitals</p>
    <div class="tenant-info">
        <strong>Hospital:</strong> <?= e($currentTenant['name']) ?><br>
        <strong>Phone:</strong> <?= e($currentTenant['phone']) ?><br>
        <strong>Email:</strong> <?= e($currentTenant['email']) ?>
    </div>
</div>

<!-- Login Options Section -->
<div class="card" style="margin-bottom: 3rem;">
    <h2 style="text-align: center; margin-bottom: 2rem; font-size: 2rem;">Select Login Type</h2>
    <div class="grid">
        <!-- Staff Login -->
        <div class="card" style="border: 3px solid #3b82f6; background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%); cursor: pointer; transition: transform 0.3s;">
            <div style="text-align: center;">
                <div style="width: 80px; height: 80px; background: #3b82f6; color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 1rem; font-size: 2rem; font-weight: bold;">S</div>
                <h2 style="color: #1e40af; margin-bottom: 1rem;">Staff Login</h2>
                <p style="color: #1e3a8a; margin-bottom: 1.5rem; font-size: 0.95rem;">
                    For Doctors, Nurses, Pharmacists, Lab Scientists, Accountants, Cooks, and all hospital staff members
                </p>
                <a href="?action=staff_login" class="btn btn-primary" style="background: #3b82f6; width: 100%;">Login as Staff</a>
            </div>
        </div>

        <!-- Hospital Admin Login -->
        <div class="card" style="border: 3px solid #10b981; background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%); cursor: pointer; transition: transform 0.3s;">
            <div style="text-align: center;">
                <div style="width: 80px; height: 80px; background: #10b981; color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 1rem; font-size: 2rem; font-weight: bold;">A</div>
                <h2 style="color: #065f46; margin-bottom: 1rem;">Hospital Admin</h2>
                <p style="color: #064e3b; margin-bottom: 1.5rem; font-size: 0.95rem;">
                    For Hospital Administrators who manage settings, users, and overall hospital operations
                </p>
                <a href="?action=admin_login" class="btn btn-primary" style="background: #10b981; width: 100%;">Login as Admin</a>
            </div>
        </div>

        <!-- Super Admin Login -->
        <div class="card" style="border: 3px solid #ef4444; background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%); cursor: pointer; transition: transform 0.3s;">
            <div style="text-align: center;">
                <div style="width: 80px; height: 80px; background: #ef4444; color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 1rem; font-size: 2rem; font-weight: bold;">SA</div>
                <h2 style="color: #991b1b; margin-bottom: 1rem;">Super Admin</h2>
                <p style="color: #7f1d1d; margin-bottom: 1.5rem; font-size: 0.95rem;">
                    For System Administrators who manage all hospitals and tenants in the entire system
                </p>
                <a href="?action=super_login" class="btn btn-primary" style="background: #ef4444; width: 100%;">Login as Super Admin</a>
            </div>
        </div>
    </div>
</div>

<!-- Hospital Registration -->
<div style="text-align: center; margin: 2rem 0;">
    <p style="font-size: 1.1rem; color: var(--text-light); margin-bottom: 1rem;">Don't have an account?</p>
    <a href="?action=register_hospital" class="btn btn-primary" style="background: white; color: #10b981; border: 2px solid #10b981; padding: 1rem 2rem; font-size: 1.1rem;">Register Your Hospital</a>
</div>

<!-- Features Section -->
<div class="card">
    <h2>Our Services & Features</h2>
    <div class="grid">
        <div class="feature-card">
            <div class="feature-icon">P</div>
            <h3>Patient Management</h3>
            <p>Comprehensive patient registration, medical history, and records management system</p>
        </div>

        <div class="feature-card">
            <div class="feature-icon">D</div>
            <h3>Doctor Management</h3>
            <p>Manage doctor profiles, specializations, schedules, and availability</p>
        </div>

        <div class="feature-card">
            <div class="feature-icon">A</div>
            <h3>Appointment Scheduling</h3>
            <p>Easy-to-use appointment booking system with calendar integration</p>
        </div>

        <div class="feature-card">
            <div class="feature-icon">B</div>
            <h3>Billing & Invoicing</h3>
            <p>Automated billing, invoice generation, and payment tracking</p>
        </div>

        <div class="feature-card">
            <div class="feature-icon">M</div>
            <h3>Medical Records</h3>
            <p>Secure electronic medical records with diagnosis and prescription tracking</p>
        </div>

        <div class="feature-card">
            <div class="feature-icon">R</div>
            <h3>Reports & Analytics</h3>
            <p>Comprehensive reporting and analytics for better decision making</p>
        </div>
    </div>
</div>

<!-- About Section -->
<div class="card">
    <h2>About Our System</h2>
    <p style="margin-bottom: 1rem;">
        Our Multi-Tenant Hospital Management System is designed to streamline healthcare operations
        and improve patient care. Built with modern web technologies, it provides a comprehensive
        solution for hospitals of all sizes.
    </p>
    <div class="grid">
        <div>
            <h3>Key Benefits</h3>
            <ul style="line-height: 2; color: var(--text-light);">
                <li>Improved patient care coordination</li>
                <li>Reduced administrative overhead</li>
                <li>Enhanced data security and privacy</li>
                <li>Real-time access to medical information</li>
                <li>Streamlined billing processes</li>
            </ul>
        </div>
        <div>
            <h3>Multi-Tenant Architecture</h3>
            <ul style="line-height: 2; color: var(--text-light);">
                <li>Complete data isolation per hospital</li>
                <li>Customizable branding and settings</li>
                <li>Scalable infrastructure</li>
                <li>Cost-effective solution</li>
                <li>Easy tenant management</li>
            </ul>
        </div>
    </div>
</div>

<!-- Demo Credentials -->
<div class="card" style="background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%); border-left: 4px solid #f59e0b;">
    <h2>Demo Credentials</h2>
    <p style="margin-bottom: 1rem;">You can login to the system using these demo credentials:</p>
    <div style="background: white; padding: 1rem; border-radius: 8px; display: inline-block;">
        <strong>Username:</strong> admin<br>
        <strong>Password:</strong> admin123
    </div>
</div>
