<div class="hero">
    <h1>Login to <?= e($currentTenant['name']) ?></h1>
    <p>Enter your credentials to access the hospital management system</p>
</div>

<div class="card" style="max-width: 500px; margin: 2rem auto;">
    <h2>Login</h2>
    <?php if (isset($error)): ?>
        <div class="alert alert-error"><?= e($error) ?></div>
    <?php endif; ?>

    <?php if (!$currentTenant || !isset($currentTenant['id'])): ?>
        <div class="alert alert-error">Error: No hospital selected. Please go back to home page.</div>
    <?php else: ?>
    <form method="POST" action="./index.php?action=login">
        <input type="hidden" name="tenant_id" value="<?= e($currentTenant['id']) ?>">
        <input type="hidden" name="tenant_name" value="<?= e($currentTenant['name']) ?>">

        <div class="form-group">
            <label for="username">Username</label>
            <input type="text" id="username" name="username" class="form-control" required autofocus>
        </div>

        <div class="form-group">
            <label for="password">Password</label>
            <input type="password" id="password" name="password" class="form-control" required>
        </div>

        <button type="submit" name="login" class="btn btn-primary btn-block">Login</button>
    </form>

    <div style="margin-top: 2rem; padding: 1rem; background: var(--light-color); border-radius: 8px;">
        <strong>Demo Credentials:</strong><br>
        Username: <code>admin</code><br>
        Password: <code>admin123</code>
    </div>

    <div style="margin-top: 1rem; padding: 1rem; background: #dbeafe; border-radius: 8px;">
        <strong>More Demo Accounts:</strong><br>
        <small>Doctor: <code>doctor1</code> / <code>doctor123</code></small><br>
        <small>Nurse: <code>nurse</code> / <code>nurse123</code></small><br>
        <small>Pharmacist: <code>pharmacist1</code> / <code>pharm123</code></small><br>
        <small>Accountant: <code>accountant</code> / <code>account123</code></small><br>
        <small>See <a href="DEMO_CREDENTIALS.md" target="_blank">DEMO_CREDENTIALS.md</a> for all 14 accounts</small>
    </div>
    <?php endif; ?>
</div>
