<?php
$db = Database::getInstance()->getConnection();

// Check if user is a nurse
$allowedRoles = ['nurse', 'hospital_admin'];
if (!in_array($_SESSION['role'], $allowedRoles)) {
    echo '<div class="alert alert-error">Access denied. Only Nurses can record patient observations.</div>';
    return;
}

$tenantId = $_SESSION['tenant_id'];
$userId = $_SESSION['user_id'];
$userName = $_SESSION['full_name'];

// Handle form submission for new observation
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['record_observation'])) {
    $patientId = $_POST['patient_id'];

    // Generate observation number
    $observationNumber = 'OBS' . date('Ymd') . str_pad($db->query("SELECT COUNT(*) FROM nurse_observations WHERE tenant_id = $tenantId")->fetchColumn() + 1, 4, '0', STR_PAD_LEFT);

    // Insert observation
    $stmt = $db->prepare("INSERT INTO nurse_observations (tenant_id, patient_id, observation_number, blood_pressure, temperature, weight, pulse_rate, respiratory_rate, oxygen_saturation, blood_sugar, observations, nurse_id, nurse_name)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    if ($stmt->execute([
        $tenantId,
        $patientId,
        $observationNumber,
        $_POST['blood_pressure'] ?: null,
        $_POST['temperature'] ?: null,
        $_POST['weight'] ?: null,
        $_POST['pulse_rate'] ?: null,
        $_POST['respiratory_rate'] ?: null,
        $_POST['oxygen_saturation'] ?: null,
        $_POST['blood_sugar'] ?: null,
        $_POST['observations'],
        $userId,
        $userName
    ])) {
        $message = "Observation recorded successfully! Observation Number: $observationNumber";
    } else {
        $error = "Failed to record observation.";
    }
}

// Get selected patient if any
$selectedPatient = null;
$patientObservations = [];
if (isset($_GET['patient_id'])) {
    $patientId = $_GET['patient_id'];
    $stmt = $db->prepare("SELECT * FROM patients WHERE id = ? AND tenant_id = ?");
    $stmt->execute([$patientId, $tenantId]);
    $selectedPatient = $stmt->fetch(PDO::FETCH_ASSOC);

    // Get all observations for this patient
    if ($selectedPatient) {
        $stmt = $db->prepare("SELECT * FROM nurse_observations WHERE patient_id = ? AND tenant_id = ? ORDER BY created_at DESC");
        $stmt->execute([$patientId, $tenantId]);
        $patientObservations = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}

// Search patients
$searchResults = [];
if (isset($_GET['search']) && !empty($_GET['search_query'])) {
    $searchQuery = '%' . $_GET['search_query'] . '%';
    $stmt = $db->prepare("SELECT * FROM patients WHERE tenant_id = ? AND (full_name LIKE ? OR patient_number LIKE ?) LIMIT 10");
    $stmt->execute([$tenantId, $searchQuery, $searchQuery]);
    $searchResults = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>

<div class="card">
    <h2>Nurse Observations & Vital Signs</h2>
    <p>Record patient vital signs and nursing observations</p>

    <?php if (isset($message)): ?>
        <div class="alert alert-success"><?= e($message) ?></div>
    <?php endif; ?>

    <?php if (isset($error)): ?>
        <div class="alert alert-error"><?= e($error) ?></div>
    <?php endif; ?>
</div>

<!-- Search Patient -->
<div class="card">
    <h3>Search Patient</h3>
    <form method="GET" action="?action=nurse_observations">
        <input type="hidden" name="action" value="nurse_observations">
        <div class="form-group">
            <label for="search_query">Search by Patient Name or Number</label>
            <div style="display: flex; gap: 0.5rem;">
                <input type="text" id="search_query" name="search_query" class="form-control"
                    placeholder="Enter patient name or number"
                    value="<?= e($_GET['search_query'] ?? '') ?>" required>
                <button type="submit" name="search" class="btn btn-primary">Search</button>
            </div>
        </div>
    </form>

    <?php if (!empty($searchResults)): ?>
        <div style="margin-top: 1rem;">
            <h4>Search Results:</h4>
            <table class="table">
                <thead>
                    <tr>
                        <th>Patient Number</th>
                        <th>Name</th>
                        <th>Gender</th>
                        <th>Age</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($searchResults as $patient): ?>
                        <tr>
                            <td><?= e($patient['patient_number']) ?></td>
                            <td><?= e($patient['full_name']) ?></td>
                            <td><?= e($patient['gender']) ?></td>
                            <td><?php
                                $dob = new DateTime($patient['date_of_birth']);
                                $now = new DateTime();
                                echo $now->diff($dob)->y;
                            ?> years</td>
                            <td>
                                <a href="?action=nurse_observations&patient_id=<?= $patient['id'] ?>" class="btn btn-primary">Select</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>

<?php if ($selectedPatient): ?>
    <!-- Patient Information -->
    <div class="card" style="background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%); border-left: 4px solid #3b82f6;">
        <h3>Selected Patient</h3>
        <div class="grid">
            <div>
                <p><strong>Patient Number:</strong> <?= e($selectedPatient['patient_number']) ?></p>
                <p><strong>Full Name:</strong> <?= e($selectedPatient['full_name']) ?></p>
                <p><strong>Gender:</strong> <?= e($selectedPatient['gender']) ?></p>
            </div>
            <div>
                <p><strong>Age:</strong> <?php
                    $dob = new DateTime($selectedPatient['date_of_birth']);
                    $now = new DateTime();
                    echo $now->diff($dob)->y;
                ?> years</p>
                <p><strong>Phone:</strong> <?= e($selectedPatient['phone']) ?></p>
                <p><strong>Blood Group:</strong> <?= e($selectedPatient['blood_group']) ?></p>
            </div>
        </div>
    </div>

    <!-- Record New Observation -->
    <div class="card">
        <h3>Record Vital Signs & Observations</h3>
        <form method="POST" action="?action=nurse_observations&patient_id=<?= $selectedPatient['id'] ?>">
            <input type="hidden" name="patient_id" value="<?= $selectedPatient['id'] ?>">

            <div style="background: #f0f9ff; padding: 1.5rem; border-radius: 8px; margin-bottom: 1.5rem;">
                <h4 style="margin-bottom: 1rem; color: #1e40af;">Vital Signs</h4>

                <div class="grid">
                    <div class="form-group">
                        <label for="blood_pressure">Blood Pressure (mmHg)</label>
                        <input type="text" id="blood_pressure" name="blood_pressure" class="form-control"
                            placeholder="e.g., 120/80">
                    </div>

                    <div class="form-group">
                        <label for="temperature">Temperature (°C)</label>
                        <input type="number" step="0.1" id="temperature" name="temperature" class="form-control"
                            placeholder="e.g., 37.5">
                    </div>

                    <div class="form-group">
                        <label for="pulse_rate">Pulse Rate (bpm)</label>
                        <input type="number" id="pulse_rate" name="pulse_rate" class="form-control"
                            placeholder="e.g., 72">
                    </div>

                    <div class="form-group">
                        <label for="respiratory_rate">Respiratory Rate (breaths/min)</label>
                        <input type="number" id="respiratory_rate" name="respiratory_rate" class="form-control"
                            placeholder="e.g., 16">
                    </div>

                    <div class="form-group">
                        <label for="oxygen_saturation">Oxygen Saturation (SpO2 %)</label>
                        <input type="number" id="oxygen_saturation" name="oxygen_saturation" class="form-control"
                            placeholder="e.g., 98">
                    </div>

                    <div class="form-group">
                        <label for="weight">Weight (kg)</label>
                        <input type="number" step="0.1" id="weight" name="weight" class="form-control"
                            placeholder="e.g., 70.5">
                    </div>

                    <div class="form-group">
                        <label for="blood_sugar">Blood Sugar (mg/dL)</label>
                        <input type="number" step="0.1" id="blood_sugar" name="blood_sugar" class="form-control"
                            placeholder="e.g., 110">
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="observations">Nursing Observations & Comments <span style="color: red;">*</span></label>
                <textarea id="observations" name="observations" class="form-control"
                    rows="8" placeholder="Record your observations about the patient's condition, behavior, symptoms, concerns, etc." required></textarea>
                <small style="color: var(--text-light);">
                    Include patient's general condition, any complaints, behavioral observations, medication administration notes, etc.
                </small>
            </div>

            <button type="submit" name="record_observation" class="btn btn-primary btn-block">Record Observation</button>
        </form>
    </div>

    <!-- Previous Observations -->
    <div class="card">
        <h3>Previous Observations (<?= count($patientObservations) ?>)</h3>

        <?php if (empty($patientObservations)): ?>
            <p style="color: var(--text-light); text-align: center; padding: 2rem; background: #f9fafb; border-radius: 8px;">
                No observations recorded for this patient yet.
            </p>
        <?php else: ?>
            <?php foreach ($patientObservations as $obs): ?>
                <div style="border: 1px solid #3b82f6; border-radius: 8px; padding: 1.5rem; margin-bottom: 1rem; background: #eff6ff;">
                    <div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 1rem;">
                        <div>
                            <h4 style="margin-bottom: 0.5rem; color: #1e40af;">Observation #<?= e($obs['observation_number']) ?></h4>
                            <p style="margin: 0; font-size: 0.85rem; color: var(--text-light);">
                                <strong>Recorded by:</strong> <?= e($obs['nurse_name']) ?> |
                                <strong>Date:</strong> <?= date('F j, Y g:i A', strtotime($obs['created_at'])) ?>
                            </p>
                        </div>
                    </div>

                    <div style="background: white; padding: 1rem; border-radius: 6px; margin-bottom: 1rem;">
                        <h5 style="color: #1e40af; margin-bottom: 0.75rem;">Vital Signs</h5>
                        <div class="grid" style="grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem;">
                            <?php if ($obs['blood_pressure']): ?>
                                <div>
                                    <strong style="color: #6b7280;">Blood Pressure:</strong><br>
                                    <span style="font-size: 1.1rem; color: #1e40af;"><?= e($obs['blood_pressure']) ?> mmHg</span>
                                </div>
                            <?php endif; ?>

                            <?php if ($obs['temperature']): ?>
                                <div>
                                    <strong style="color: #6b7280;">Temperature:</strong><br>
                                    <span style="font-size: 1.1rem; color: #1e40af;"><?= e($obs['temperature']) ?> °C</span>
                                </div>
                            <?php endif; ?>

                            <?php if ($obs['pulse_rate']): ?>
                                <div>
                                    <strong style="color: #6b7280;">Pulse Rate:</strong><br>
                                    <span style="font-size: 1.1rem; color: #1e40af;"><?= e($obs['pulse_rate']) ?> bpm</span>
                                </div>
                            <?php endif; ?>

                            <?php if ($obs['respiratory_rate']): ?>
                                <div>
                                    <strong style="color: #6b7280;">Respiratory Rate:</strong><br>
                                    <span style="font-size: 1.1rem; color: #1e40af;"><?= e($obs['respiratory_rate']) ?> breaths/min</span>
                                </div>
                            <?php endif; ?>

                            <?php if ($obs['oxygen_saturation']): ?>
                                <div>
                                    <strong style="color: #6b7280;">SpO2:</strong><br>
                                    <span style="font-size: 1.1rem; color: #1e40af;"><?= e($obs['oxygen_saturation']) ?> %</span>
                                </div>
                            <?php endif; ?>

                            <?php if ($obs['weight']): ?>
                                <div>
                                    <strong style="color: #6b7280;">Weight:</strong><br>
                                    <span style="font-size: 1.1rem; color: #1e40af;"><?= e($obs['weight']) ?> kg</span>
                                </div>
                            <?php endif; ?>

                            <?php if ($obs['blood_sugar']): ?>
                                <div>
                                    <strong style="color: #6b7280;">Blood Sugar:</strong><br>
                                    <span style="font-size: 1.1rem; color: #1e40af;"><?= e($obs['blood_sugar']) ?> mg/dL</span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div style="background: white; padding: 1rem; border-radius: 6px; border-left: 4px solid #3b82f6;">
                        <h5 style="color: #1e40af; margin-bottom: 0.5rem;">Nursing Observations</h5>
                        <p style="white-space: pre-wrap; margin: 0; line-height: 1.6; color: #374151;"><?= e($obs['observations']) ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
<?php else: ?>
    <div class="card" style="text-align: center; padding: 3rem;">
        <p style="color: var(--text-light); font-size: 1.1rem;">Search for a patient above to record observations</p>
    </div>
<?php endif; ?>
