<?php
$db = Database::getInstance()->getConnection();
$tenantId = $_SESSION['tenant_id'];
$subAction = $_GET['sub'] ?? 'search';

// Check if user is a nurse
$canAccessNurseStation = in_array($_SESSION['role'], ['hospital_admin', 'nurse', 'doctor']);

if (!$canAccessNurseStation) {
    header('Location: ?action=dashboard');
    exit;
}

// Handle vital signs submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_vitals'])) {
    $stmt = $db->prepare("
        INSERT INTO medical_records (tenant_id, patient_id, recorded_by, record_type, blood_pressure, temperature, pulse_rate, weight, height, respiratory_rate, notes)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");

    $stmt->execute([
        $tenantId,
        $_POST['patient_id'],
        $_SESSION['user_id'],
        'vital_signs',
        $_POST['blood_pressure'],
        $_POST['temperature'],
        $_POST['pulse_rate'],
        $_POST['weight'],
        $_POST['height'],
        $_POST['respiratory_rate'],
        $_POST['notes']
    ]);

    $message = 'Vital signs recorded successfully!';
}

// Patient search
$searchResults = [];
$selectedPatient = null;

if (isset($_GET['search']) && !empty($_GET['search_query'])) {
    $searchQuery = '%' . $_GET['search_query'] . '%';
    $stmt = $db->prepare("
        SELECT * FROM patients
        WHERE tenant_id = ? AND (patient_number LIKE ? OR full_name LIKE ?)
        ORDER BY full_name
        LIMIT 20
    ");
    $stmt->execute([$tenantId, $searchQuery, $searchQuery]);
    $searchResults = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Get patient details and history if patient selected
if ($subAction === 'vitals' && isset($_GET['patient_id'])) {
    $stmt = $db->prepare("SELECT * FROM patients WHERE id = ? AND tenant_id = ?");
    $stmt->execute([$_GET['patient_id'], $tenantId]);
    $selectedPatient = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($selectedPatient) {
        // Get medical records history
        $historyStmt = $db->prepare("
            SELECT mr.*, u.full_name as recorded_by_name
            FROM medical_records mr
            LEFT JOIN users u ON mr.recorded_by = u.id
            WHERE mr.patient_id = ? AND mr.tenant_id = ?
            ORDER BY mr.created_at DESC
            LIMIT 10
        ");
        $historyStmt->execute([$_GET['patient_id'], $tenantId]);
        $medicalHistory = $historyStmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
?>

<div class="hero">
    <h1>Nurse Station</h1>
    <p>Patient search and vital signs recording</p>
</div>

<?php if (isset($message)): ?>
    <div class="alert alert-success"><?= e($message) ?></div>
<?php endif; ?>

<?php if ($subAction === 'search' || !$selectedPatient): ?>
    <!-- Patient Search -->
    <div class="card">
        <h2>Search Patient</h2>
        <p style="color: var(--text-dark); margin-bottom: 1.5rem;">
            Search by patient number or patient name to access medical records and record vital signs.
        </p>

        <form method="GET" action="?action=nurse_station">
            <input type="hidden" name="action" value="nurse_station">
            <input type="hidden" name="search" value="1">

            <div style="display: flex; gap: 1rem; flex-wrap: wrap;">
                <div style="flex: 1; min-width: 300px;">
                    <input type="text" name="search_query" class="form-control"
                           placeholder="Enter patient number (e.g., PAT00001) or patient name"
                           value="<?= e($_GET['search_query'] ?? '') ?>" required>
                </div>
                <button type="submit" class="btn btn-primary">Search</button>
            </div>
        </form>
    </div>

    <?php if (count($searchResults) > 0): ?>
        <!-- Search Results -->
        <div class="card">
            <h2>Search Results (<?= count($searchResults) ?>)</h2>
            <div style="overflow-x: auto;">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Patient #</th>
                            <th>Full Name</th>
                            <th>DOB</th>
                            <th>Gender</th>
                            <th>Blood Group</th>
                            <th>Phone</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($searchResults as $patient): ?>
                            <tr>
                                <td><strong><?= e($patient['patient_number']) ?></strong></td>
                                <td><?= e($patient['full_name']) ?></td>
                                <td><?= $patient['date_of_birth'] ? e(date('M j, Y', strtotime($patient['date_of_birth']))) : 'N/A' ?></td>
                                <td><?= e($patient['gender'] ?? 'N/A') ?></td>
                                <td><?= e($patient['blood_group'] ?? 'N/A') ?></td>
                                <td><?= e($patient['phone'] ?? 'N/A') ?></td>
                                <td>
                                    <a href="?action=nurse_station&sub=vitals&patient_id=<?= $patient['id'] ?>" class="btn btn-primary" style="padding: 0.5rem 1rem; font-size: 0.875rem;">
                                        Record Vitals
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php elseif (isset($_GET['search'])): ?>
        <div class="card">
            <p style="text-align: center; padding: 2rem; color: var(--text-light);">
                No patients found matching your search. Please try again.
            </p>
        </div>
    <?php endif; ?>

<?php elseif ($subAction === 'vitals' && $selectedPatient): ?>
    <!-- Patient Information -->
    <div class="card">
        <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 1rem; margin-bottom: 1.5rem;">
            <h2>Patient Information</h2>
            <a href="?action=nurse_station" class="btn btn-secondary">← Back to Search</a>
        </div>

        <div class="grid">
            <div>
                <p><strong>Patient Number:</strong> <?= e($selectedPatient['patient_number']) ?></p>
                <p><strong>Full Name:</strong> <?= e($selectedPatient['full_name']) ?></p>
                <p><strong>Date of Birth:</strong> <?= $selectedPatient['date_of_birth'] ? e(date('F j, Y', strtotime($selectedPatient['date_of_birth']))) : 'N/A' ?></p>
            </div>
            <div>
                <p><strong>Gender:</strong> <?= e($selectedPatient['gender'] ?? 'N/A') ?></p>
                <p><strong>Blood Group:</strong> <?= e($selectedPatient['blood_group'] ?? 'N/A') ?></p>
                <p><strong>Phone:</strong> <?= e($selectedPatient['phone'] ?? 'N/A') ?></p>
            </div>
        </div>
    </div>

    <!-- Record Vital Signs -->
    <div class="card">
        <h2>Record Vital Signs</h2>
        <form method="POST" action="?action=nurse_station&sub=vitals&patient_id=<?= $selectedPatient['id'] ?>">
            <input type="hidden" name="patient_id" value="<?= $selectedPatient['id'] ?>">

            <div class="grid">
                <div class="form-group">
                    <label for="blood_pressure">Blood Pressure (mmHg) *</label>
                    <input type="text" id="blood_pressure" name="blood_pressure" class="form-control"
                           placeholder="e.g., 120/80" required>
                    <small style="color: var(--text-light);">Format: Systolic/Diastolic</small>
                </div>

                <div class="form-group">
                    <label for="temperature">Temperature (°F) *</label>
                    <input type="number" id="temperature" name="temperature" class="form-control"
                           step="0.1" min="90" max="110" placeholder="e.g., 98.6" required>
                </div>

                <div class="form-group">
                    <label for="pulse_rate">Pulse Rate (bpm) *</label>
                    <input type="number" id="pulse_rate" name="pulse_rate" class="form-control"
                           min="40" max="200" placeholder="e.g., 72" required>
                    <small style="color: var(--text-light);">Beats per minute</small>
                </div>

                <div class="form-group">
                    <label for="respiratory_rate">Respiratory Rate (breaths/min)</label>
                    <input type="number" id="respiratory_rate" name="respiratory_rate" class="form-control"
                           min="8" max="40" placeholder="e.g., 16">
                </div>

                <div class="form-group">
                    <label for="weight">Weight (kg)</label>
                    <input type="number" id="weight" name="weight" class="form-control"
                           step="0.1" min="0" max="300" placeholder="e.g., 70.5">
                </div>

                <div class="form-group">
                    <label for="height">Height (cm)</label>
                    <input type="number" id="height" name="height" class="form-control"
                           step="0.1" min="0" max="250" placeholder="e.g., 175">
                </div>
            </div>

            <div class="form-group">
                <label for="notes">Additional Notes</label>
                <textarea id="notes" name="notes" class="form-control" rows="3"
                          placeholder="Any observations or additional information"></textarea>
            </div>

            <button type="submit" name="save_vitals" class="btn btn-primary">Save Vital Signs</button>
        </form>
    </div>

    <!-- Medical History -->
    <?php if (isset($medicalHistory) && count($medicalHistory) > 0): ?>
        <div class="card">
            <h2>Recent Vital Signs History</h2>
            <div style="overflow-x: auto;">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Date & Time</th>
                            <th>BP</th>
                            <th>Temp (°F)</th>
                            <th>Pulse</th>
                            <th>Weight (kg)</th>
                            <th>Height (cm)</th>
                            <th>Resp. Rate</th>
                            <th>Recorded By</th>
                            <th>Notes</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($medicalHistory as $record): ?>
                            <tr>
                                <td><?= e(date('M j, Y g:i A', strtotime($record['created_at']))) ?></td>
                                <td><?= e($record['blood_pressure'] ?? '-') ?></td>
                                <td><?= e($record['temperature'] ?? '-') ?></td>
                                <td><?= e($record['pulse_rate'] ?? '-') ?></td>
                                <td><?= e($record['weight'] ?? '-') ?></td>
                                <td><?= e($record['height'] ?? '-') ?></td>
                                <td><?= e($record['respiratory_rate'] ?? '-') ?></td>
                                <td><?= e($record['recorded_by_name']) ?></td>
                                <td><?= e($record['notes'] ?? '-') ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif; ?>
<?php endif; ?>
