<?php
// Patient Card Generation & Print
$db = Database::getInstance()->getConnection();
$tenantId = $_SESSION['tenant_id'];

if (!isset($_GET['id'])) {
    header('Location: ?action=patients');
    exit;
}

// Handle email card request
if (isset($_GET['send_email']) && $_GET['send_email'] === '1') {
    $patientId = $_GET['id'];

    // Get patient and hospital details
    $stmt = $db->prepare("
        SELECT p.*, t.name as hospital_name, t.email as hospital_email
        FROM patients p
        JOIN tenants t ON p.tenant_id = t.id
        WHERE p.id = ? AND p.tenant_id = ?
    ");
    $stmt->execute([$patientId, $tenantId]);
    $patientData = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($patientData && $patientData['email']) {
        // Create email message
        $emailMessage = "
        <!DOCTYPE html>
        <html>
        <head>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; }
                .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px; text-align: center; }
                .content { padding: 20px; }
                .card-info { background: #f4f4f4; padding: 15px; border-radius: 8px; margin: 20px 0; }
                .footer { text-align: center; padding: 20px; color: #666; font-size: 0.875rem; }
            </style>
        </head>
        <body>
            <div class='header'>
                <h1>{$patientData['hospital_name']}</h1>
                <p>Patient Identification Card</p>
            </div>
            <div class='content'>
                <h2>Dear " . e($patientData['full_name']) . ",</h2>
                <p>Your patient identification card has been generated successfully.</p>

                <div class='card-info'>
                    <h3>Your Patient Details:</h3>
                    <p><strong>Patient Number:</strong> {$patientData['patient_number']}</p>
                    <p><strong>Name:</strong> {$patientData['full_name']}</p>
                    <p><strong>Date of Birth:</strong> " . ($patientData['date_of_birth'] ? date('F j, Y', strtotime($patientData['date_of_birth'])) : 'N/A') . "</p>
                    <p><strong>Blood Group:</strong> " . ($patientData['blood_group'] ?? 'N/A') . "</p>
                    <p><strong>Gender:</strong> " . ($patientData['gender'] ?? 'N/A') . "</p>
                </div>

                <p>Please present this patient number during your visits to our facility.</p>
                <p>You can also print your physical card by visiting our facility or accessing the patient portal.</p>
            </div>
            <div class='footer'>
                <p>This is an automated message from {$patientData['hospital_name']}</p>
                <p>If you have any questions, please contact us.</p>
            </div>
        </body>
        </html>
        ";

        $emailSent = sendEmail(
            $patientData['email'],
            "Your Patient ID Card - {$patientData['hospital_name']}",
            $emailMessage,
            $patientData['hospital_name'],
            $patientData['hospital_email']
        );

        if ($emailSent) {
            $emailSuccess = "Patient card has been emailed to " . e($patientData['email']);
        } else {
            $emailError = "Failed to send email. Please check server email configuration.";
        }
    } else {
        $emailError = "Patient email address not available.";
    }
}

// Get patient details
$stmt = $db->prepare("
    SELECT p.*, t.name as hospital_name, t.address as hospital_address, t.phone as hospital_phone, t.email as hospital_email
    FROM patients p
    JOIN tenants t ON p.tenant_id = t.id
    WHERE p.id = ? AND p.tenant_id = ?
");
$stmt->execute([$_GET['id'], $tenantId]);
$patient = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$patient) {
    header('Location: ?action=patients');
    exit;
}

// Generate QR code data (patient number for quick lookup)
$qrData = $patient['patient_number'];
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Patient Card - <?= e($patient['full_name']) ?></title>
    <style>
        @page {
            size: 3.5in 2in;
            margin: 0;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            background: #f0f0f0;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }

        .card-container {
            background: white;
            padding: 20px;
        }

        .patient-card {
            width: 3.5in;
            height: 2in;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 12px;
            padding: 15px;
            color: white;
            position: relative;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            overflow: hidden;
        }

        .card-header {
            border-bottom: 1px solid rgba(255,255,255,0.3);
            padding-bottom: 8px;
            margin-bottom: 10px;
        }

        .hospital-name {
            font-size: 11px;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .card-title {
            font-size: 9px;
            opacity: 0.9;
            margin-top: 2px;
        }

        .card-body {
            display: flex;
            justify-content: space-between;
        }

        .patient-info {
            flex: 1;
        }

        .info-row {
            margin-bottom: 5px;
            font-size: 9px;
        }

        .label {
            opacity: 0.8;
            font-size: 7px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .value {
            font-weight: bold;
            font-size: 10px;
            margin-top: 1px;
        }

        .patient-number {
            background: rgba(255,255,255,0.2);
            padding: 4px 8px;
            border-radius: 4px;
            display: inline-block;
            font-size: 12px;
            font-weight: bold;
            letter-spacing: 1px;
        }

        .qr-section {
            width: 60px;
            height: 60px;
            background: white;
            border-radius: 6px;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 5px;
        }

        .qr-code {
            width: 100%;
            height: 100%;
            background: #333;
            border-radius: 4px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 8px;
            color: white;
            text-align: center;
            padding: 5px;
        }

        .card-footer {
            position: absolute;
            bottom: 10px;
            left: 15px;
            right: 15px;
            font-size: 7px;
            opacity: 0.8;
            display: flex;
            justify-content: space-between;
        }

        .buttons {
            margin-top: 20px;
            text-align: center;
        }

        .btn {
            padding: 10px 20px;
            margin: 0 5px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            text-decoration: none;
            display: inline-block;
        }

        .btn-print {
            background: #2563eb;
            color: white;
        }

        .btn-email {
            background: #10b981;
            color: white;
        }

        .btn-back {
            background: #6b7280;
            color: white;
        }

        @media print {
            body {
                background: white;
                padding: 0;
            }

            .card-container {
                padding: 0;
            }

            .buttons {
                display: none;
            }
        }
    </style>
</head>
<body>
    <?php if (isset($emailSuccess)): ?>
        <div style="background: #d1fae5; color: #065f46; padding: 1rem; margin: 1rem; border-radius: 8px; text-align: center;">
            <?= $emailSuccess ?>
        </div>
    <?php endif; ?>

    <?php if (isset($emailError)): ?>
        <div style="background: #fee2e2; color: #991b1b; padding: 1rem; margin: 1rem; border-radius: 8px; text-align: center;">
            <?= $emailError ?>
        </div>
    <?php endif; ?>

    <?php if (isset($_GET['invoice_created']) && $_GET['invoice_created'] === '1'): ?>
        <div style="background: #dbeafe; color: #1e40af; padding: 1rem; margin: 1rem; border-radius: 8px; text-align: center;">
            <strong>Patient card invoice created!</strong> Please proceed to billing to process payment before printing the card.
        </div>
    <?php endif; ?>

    <div class="card-container">
        <div class="patient-card">
            <div class="card-header">
                <div class="hospital-name"><?= e($patient['hospital_name']) ?></div>
                <div class="card-title">Patient Identification Card</div>
            </div>

            <div class="card-body">
                <div class="patient-info">
                    <div class="info-row">
                        <div class="label">Patient No.</div>
                        <div class="patient-number"><?= e($patient['patient_number']) ?></div>
                    </div>

                    <div class="info-row">
                        <div class="label">Patient Name</div>
                        <div class="value"><?= e(strtoupper($patient['full_name'])) ?></div>
                    </div>

                    <div class="info-row">
                        <div class="label">Date of Birth</div>
                        <div class="value"><?= $patient['date_of_birth'] ? e(date('M j, Y', strtotime($patient['date_of_birth']))) : 'N/A' ?></div>
                    </div>

                    <div class="info-row">
                        <div class="label">Blood Group</div>
                        <div class="value"><?= e($patient['blood_group'] ?? 'N/A') ?> | <?= e($patient['gender'] ?? 'N/A') ?></div>
                    </div>
                </div>

                <div class="qr-section">
                    <div class="qr-code">
                        <?= e($patient['patient_number']) ?>
                    </div>
                </div>
            </div>

            <div class="card-footer">
                <span>Issued: <?= date('M j, Y') ?></span>
                <span>Emergency: <?= e($patient['emergency_phone'] ?? $patient['hospital_phone']) ?></span>
            </div>
        </div>

        <div class="buttons">
            <button onclick="window.print()" class="btn btn-print">Print Card</button>
            <?php if ($patient['email']): ?>
                <a href="?action=patients&sub=card&id=<?= $patient['id'] ?>&send_email=1" class="btn btn-email">Email Card</a>
            <?php endif; ?>
            <a href="?action=patients" class="btn btn-back">Back to Patients</a>
        </div>
    </div>
</body>
</html>
