<?php
$db = Database::getInstance()->getConnection();
$tenantId = $_SESSION['tenant_id'];
$userRole = $_SESSION['role'];
$subAction = $_GET['sub'] ?? 'list';

// Check if user can add/edit patients (only Hospital Admin)
$canManagePatients = ($userRole === 'hospital_admin');

// If card view, redirect to dedicated page
if ($subAction === 'card' && isset($_GET['id'])) {
    include 'pages/patient_card.php';
    return;
}

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_patient']) && $canManagePatients) {
        $patientNumber = 'PAT' . str_pad($db->query("SELECT COUNT(*) FROM patients WHERE tenant_id = $tenantId")->fetchColumn() + 1, 5, '0', STR_PAD_LEFT);

        $stmt = $db->prepare("
            INSERT INTO patients (tenant_id, patient_number, full_name, date_of_birth, gender, blood_group, phone, email, address, emergency_contact, emergency_phone)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ");

        $stmt->execute([
            $tenantId,
            $patientNumber,
            $_POST['full_name'],
            $_POST['date_of_birth'],
            $_POST['gender'],
            $_POST['blood_group'],
            $_POST['phone'],
            $_POST['email'],
            $_POST['address'],
            $_POST['emergency_contact'],
            $_POST['emergency_phone']
        ]);

        $patientId = $db->lastInsertId();

        // If card requested, create billing for card fee
        if (isset($_POST['generate_card'])) {
            // Get card fee from settings
            $settingsStmt = $db->prepare("SELECT patient_card_fee FROM tenants WHERE id = ?");
            $settingsStmt->execute([$tenantId]);
            $cardFee = $settingsStmt->fetchColumn() ?? 5.00;

            // Generate invoice number
            $invoiceNumber = 'INV' . date('Ymd') . str_pad($db->query("SELECT COUNT(*) FROM billing WHERE tenant_id = $tenantId")->fetchColumn() + 1, 4, '0', STR_PAD_LEFT);

            // Create billing entry for patient card
            $billingStmt = $db->prepare("
                INSERT INTO billing (tenant_id, patient_id, invoice_number, description, amount, status)
                VALUES (?, ?, ?, ?, ?, ?)
            ");
            $billingStmt->execute([
                $tenantId,
                $patientId,
                $invoiceNumber,
                'Patient ID Card - ' . $patientNumber,
                $cardFee,
                'pending'
            ]);

            $message = 'Patient registered successfully! Patient Card invoice generated. Patient No: ' . $patientNumber;

            // Redirect to card page after success message
            header('Location: ?action=patients&sub=card&id=' . $patientId . '&invoice_created=1');
            exit;
        } else {
            $message = 'Patient registered successfully! Patient No: ' . $patientNumber;
        }

        $subAction = 'list';
    } elseif (isset($_POST['update_patient'])) {
        $stmt = $db->prepare("
            UPDATE patients SET
                full_name = ?, date_of_birth = ?, gender = ?, blood_group = ?,
                phone = ?, email = ?, address = ?, emergency_contact = ?, emergency_phone = ?
            WHERE id = ? AND tenant_id = ?
        ");

        $stmt->execute([
            $_POST['full_name'],
            $_POST['date_of_birth'],
            $_POST['gender'],
            $_POST['blood_group'],
            $_POST['phone'],
            $_POST['email'],
            $_POST['address'],
            $_POST['emergency_contact'],
            $_POST['emergency_phone'],
            $_POST['patient_id'],
            $tenantId
        ]);

        $message = 'Patient updated successfully!';
        $subAction = 'list';
    }
}

// Get patient for editing
$editPatient = null;
if ($subAction === 'edit' && isset($_GET['id'])) {
    $stmt = $db->prepare("SELECT * FROM patients WHERE id = ? AND tenant_id = ?");
    $stmt->execute([$_GET['id'], $tenantId]);
    $editPatient = $stmt->fetch(PDO::FETCH_ASSOC);
}

// Get all patients
$patients = $db->query("SELECT * FROM patients WHERE tenant_id = $tenantId ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="hero">
    <h1>Patient Management</h1>
    <p>Register and manage patient information</p>
</div>

<?php if (isset($message)): ?>
    <div class="alert alert-success"><?= e($message) ?></div>
<?php endif; ?>

<?php if ($subAction === 'add' || $subAction === 'edit'): ?>
    <!-- Add/Edit Patient Form -->
    <div class="card">
        <h2><?= $subAction === 'edit' ? 'Edit Patient' : 'Register New Patient' ?></h2>
        <form method="POST" action="?action=patients">
            <?php if ($subAction === 'edit'): ?>
                <input type="hidden" name="patient_id" value="<?= e($editPatient['id']) ?>">
            <?php endif; ?>

            <div class="grid">
                <div class="form-group">
                    <label for="full_name">Full Name *</label>
                    <input type="text" id="full_name" name="full_name" class="form-control"
                           value="<?= e($editPatient['full_name'] ?? '') ?>" required>
                </div>

                <div class="form-group">
                    <label for="date_of_birth">Date of Birth</label>
                    <input type="date" id="date_of_birth" name="date_of_birth" class="form-control"
                           value="<?= e($editPatient['date_of_birth'] ?? '') ?>">
                </div>

                <div class="form-group">
                    <label for="gender">Gender</label>
                    <select id="gender" name="gender" class="form-control">
                        <option value="">Select Gender</option>
                        <option value="Male" <?= ($editPatient['gender'] ?? '') === 'Male' ? 'selected' : '' ?>>Male</option>
                        <option value="Female" <?= ($editPatient['gender'] ?? '') === 'Female' ? 'selected' : '' ?>>Female</option>
                        <option value="Other" <?= ($editPatient['gender'] ?? '') === 'Other' ? 'selected' : '' ?>>Other</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="blood_group">Blood Group</label>
                    <select id="blood_group" name="blood_group" class="form-control">
                        <option value="">Select Blood Group</option>
                        <?php
                        $bloodGroups = ['A+', 'A-', 'B+', 'B-', 'AB+', 'AB-', 'O+', 'O-'];
                        foreach ($bloodGroups as $group):
                        ?>
                            <option value="<?= $group ?>" <?= ($editPatient['blood_group'] ?? '') === $group ? 'selected' : '' ?>><?= $group ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="phone">Phone</label>
                    <input type="tel" id="phone" name="phone" class="form-control"
                           value="<?= e($editPatient['phone'] ?? '') ?>">
                </div>

                <div class="form-group">
                    <label for="email">Email</label>
                    <input type="email" id="email" name="email" class="form-control"
                           value="<?= e($editPatient['email'] ?? '') ?>">
                </div>
            </div>

            <div class="form-group">
                <label for="address">Address</label>
                <textarea id="address" name="address" class="form-control" rows="3"><?= e($editPatient['address'] ?? '') ?></textarea>
            </div>

            <div class="grid">
                <div class="form-group">
                    <label for="emergency_contact">Emergency Contact Name</label>
                    <input type="text" id="emergency_contact" name="emergency_contact" class="form-control"
                           value="<?= e($editPatient['emergency_contact'] ?? '') ?>">
                </div>

                <div class="form-group">
                    <label for="emergency_phone">Emergency Contact Phone</label>
                    <input type="tel" id="emergency_phone" name="emergency_phone" class="form-control"
                           value="<?= e($editPatient['emergency_phone'] ?? '') ?>">
                </div>
            </div>

            <?php if ($subAction === 'add'): ?>
                <?php
                // Get card fee setting
                $cardFeeStmt = $db->prepare("SELECT patient_card_fee FROM tenants WHERE id = ?");
                $cardFeeStmt->execute([$tenantId]);
                $cardFee = $cardFeeStmt->fetchColumn() ?? 5.00;
                ?>
                <div class="form-group" style="margin-top: 1.5rem; padding: 1rem; background: var(--light-color); border-radius: 8px;">
                    <label style="display: flex; align-items: center; gap: 0.75rem; cursor: pointer;">
                        <input type="checkbox" name="generate_card" value="1" checked>
                        <span><strong>Generate Patient ID Card</strong> (Fee: <?= formatCurrency($cardFee) ?>)</span>
                    </label>
                    <small style="color: var(--text-dark); display: block; margin-top: 0.5rem; margin-left: 1.75rem;">
                        A billing invoice will be created. Patient can print or email card after payment is processed.
                    </small>
                </div>
            <?php endif; ?>

            <div style="display: flex; gap: 1rem; margin-top: 1.5rem;">
                <button type="submit" name="<?= $subAction === 'edit' ? 'update_patient' : 'add_patient' ?>" class="btn btn-primary">
                    <?= $subAction === 'edit' ? 'Update Patient' : 'Register Patient' ?>
                </button>
                <a href="?action=patients" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
<?php else: ?>
    <!-- Patient List -->
    <div class="card">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem; flex-wrap: wrap; gap: 1rem;">
            <h2>All Patients (<?= count($patients) ?>)</h2>
            <?php if ($canManagePatients): ?>
                <a href="?action=patients&sub=add" class="btn btn-primary">+ Add New Patient</a>
            <?php else: ?>
                <span style="color: var(--text-light); font-size: 0.9rem;">(View Only - Contact Admin to add patients)</span>
            <?php endif; ?>
        </div>

        <?php if (count($patients) > 0): ?>
            <div style="overflow-x: auto;">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Patient #</th>
                            <th>Name</th>
                            <th>DOB</th>
                            <th>Gender</th>
                            <th>Blood Group</th>
                            <th>Phone</th>
                            <th>Email</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($patients as $patient): ?>
                            <tr>
                                <td><strong><?= e($patient['patient_number']) ?></strong></td>
                                <td><?= e($patient['full_name']) ?></td>
                                <td><?= $patient['date_of_birth'] ? e(date('M j, Y', strtotime($patient['date_of_birth']))) : 'N/A' ?></td>
                                <td><?= e($patient['gender'] ?? 'N/A') ?></td>
                                <td><?= e($patient['blood_group'] ?? 'N/A') ?></td>
                                <td><?= e($patient['phone'] ?? 'N/A') ?></td>
                                <td><?= e($patient['email'] ?? 'N/A') ?></td>
                                <td>
                                    <div style="display: flex; gap: 0.5rem; flex-wrap: wrap;">
                                        <a href="?action=patients&sub=card&id=<?= $patient['id'] ?>" class="btn btn-primary" style="padding: 0.5rem 1rem; font-size: 0.875rem;">View Card</a>
                                        <a href="?action=patients&sub=edit&id=<?= $patient['id'] ?>" class="btn btn-secondary" style="padding: 0.5rem 1rem; font-size: 0.875rem;">Edit</a>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p style="text-align: center; padding: 3rem; color: var(--text-light);">
                No patients registered yet. Click "Add New Patient" to get started.
            </p>
        <?php endif; ?>
    </div>
<?php endif; ?>
