<?php
$db = Database::getInstance()->getConnection();
$tenantId = $_SESSION['tenant_id'];
$subAction = $_GET['sub'] ?? 'list';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_drug'])) {
        $drugCode = 'DRG' . str_pad($db->query("SELECT COUNT(*) FROM pharmacy_inventory WHERE tenant_id = $tenantId")->fetchColumn() + 1, 4, '0', STR_PAD_LEFT);

        $stmt = $db->prepare("
            INSERT INTO pharmacy_inventory (tenant_id, drug_name, generic_name, drug_code, category, dosage_form, strength, manufacturer, quantity, reorder_level, unit_price, expiry_date)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ");

        $stmt->execute([
            $tenantId,
            $_POST['drug_name'],
            $_POST['generic_name'],
            $drugCode,
            $_POST['category'],
            $_POST['dosage_form'],
            $_POST['strength'],
            $_POST['manufacturer'],
            $_POST['quantity'],
            $_POST['reorder_level'],
            $_POST['unit_price'],
            $_POST['expiry_date']
        ]);

        $message = 'Drug added successfully! Drug Code: ' . $drugCode;
        $subAction = 'list';
    } elseif (isset($_POST['update_drug'])) {
        $stmt = $db->prepare("
            UPDATE pharmacy_inventory SET
                drug_name = ?, generic_name = ?, category = ?, dosage_form = ?,
                strength = ?, manufacturer = ?, quantity = ?, reorder_level = ?,
                unit_price = ?, expiry_date = ?, status = ?
            WHERE id = ? AND tenant_id = ?
        ");

        $stmt->execute([
            $_POST['drug_name'],
            $_POST['generic_name'],
            $_POST['category'],
            $_POST['dosage_form'],
            $_POST['strength'],
            $_POST['manufacturer'],
            $_POST['quantity'],
            $_POST['reorder_level'],
            $_POST['unit_price'],
            $_POST['expiry_date'],
            $_POST['status'],
            $_POST['drug_id'],
            $tenantId
        ]);

        $message = 'Drug updated successfully!';
        $subAction = 'list';
    } elseif (isset($_POST['delete_drug'])) {
        $stmt = $db->prepare("DELETE FROM pharmacy_inventory WHERE id = ? AND tenant_id = ?");
        $stmt->execute([$_POST['drug_id'], $tenantId]);
        $message = 'Drug deleted successfully!';
        $subAction = 'list';
    }
}

// Get drug for editing
$editDrug = null;
if ($subAction === 'edit' && isset($_GET['id'])) {
    $stmt = $db->prepare("SELECT * FROM pharmacy_inventory WHERE id = ? AND tenant_id = ?");
    $stmt->execute([$_GET['id'], $tenantId]);
    $editDrug = $stmt->fetch(PDO::FETCH_ASSOC);
}

// Get inventory
$inventory = $db->query("
    SELECT * FROM pharmacy_inventory
    WHERE tenant_id = $tenantId
    ORDER BY drug_name
")->fetchAll(PDO::FETCH_ASSOC);

// Statistics
$stats = [
    'total_drugs' => count($inventory),
    'low_stock' => $db->query("SELECT COUNT(*) FROM pharmacy_inventory WHERE tenant_id = $tenantId AND quantity <= reorder_level")->fetchColumn(),
    'out_of_stock' => $db->query("SELECT COUNT(*) FROM pharmacy_inventory WHERE tenant_id = $tenantId AND quantity = 0")->fetchColumn(),
    'total_value' => $db->query("SELECT SUM(quantity * unit_price) FROM pharmacy_inventory WHERE tenant_id = $tenantId")->fetchColumn() ?? 0,
];
?>

<div class="hero">
    <h1>Pharmacy Management</h1>
    <p>Manage drug inventory and dispensing</p>
</div>

<?php if (isset($message)): ?>
    <div class="alert alert-success"><?= e($message) ?></div>
<?php endif; ?>

<div class="stats">
    <div class="stat-card">
        <div class="stat-value"><?= $stats['total_drugs'] ?></div>
        <div class="stat-label">Total Drugs</div>
    </div>
    <div class="stat-card warning">
        <div class="stat-value"><?= $stats['low_stock'] ?></div>
        <div class="stat-label">Low Stock Items</div>
    </div>
    <div class="stat-card danger">
        <div class="stat-value"><?= $stats['out_of_stock'] ?></div>
        <div class="stat-label">Out of Stock</div>
    </div>
    <div class="stat-card success">
        <div class="stat-value"><?= formatCurrency($stats['total_value']) ?></div>
        <div class="stat-label">Total Inventory Value</div>
    </div>
</div>

<?php if ($subAction === 'add' || $subAction === 'edit'): ?>
    <!-- Add/Edit Drug Form -->
    <div class="card">
        <h2><?= $subAction === 'edit' ? 'Edit Drug' : 'Add New Drug' ?></h2>
        <form method="POST" action="?action=pharmacy">
            <?php if ($subAction === 'edit'): ?>
                <input type="hidden" name="drug_id" value="<?= e($editDrug['id']) ?>">
            <?php endif; ?>

            <div class="grid">
                <div class="form-group">
                    <label for="drug_name">Drug Name *</label>
                    <input type="text" id="drug_name" name="drug_name" class="form-control"
                           value="<?= e($editDrug['drug_name'] ?? '') ?>" required>
                </div>

                <div class="form-group">
                    <label for="generic_name">Generic Name</label>
                    <input type="text" id="generic_name" name="generic_name" class="form-control"
                           value="<?= e($editDrug['generic_name'] ?? '') ?>">
                </div>

                <div class="form-group">
                    <label for="category">Category</label>
                    <input type="text" id="category" name="category" class="form-control"
                           value="<?= e($editDrug['category'] ?? '') ?>"
                           placeholder="e.g., Antibiotic, Analgesic, NSAID">
                </div>

                <div class="form-group">
                    <label for="dosage_form">Dosage Form *</label>
                    <select id="dosage_form" name="dosage_form" class="form-control" required>
                        <option value="">Select Form</option>
                        <?php
                        $forms = ['Tablet', 'Capsule', 'Syrup', 'Injection', 'Cream', 'Ointment', 'Drops', 'Inhaler'];
                        foreach ($forms as $form):
                        ?>
                            <option value="<?= $form ?>" <?= ($editDrug['dosage_form'] ?? '') === $form ? 'selected' : '' ?>><?= $form ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="strength">Strength *</label>
                    <input type="text" id="strength" name="strength" class="form-control"
                           value="<?= e($editDrug['strength'] ?? '') ?>" required
                           placeholder="e.g., 500mg, 10ml">
                </div>

                <div class="form-group">
                    <label for="manufacturer">Manufacturer</label>
                    <input type="text" id="manufacturer" name="manufacturer" class="form-control"
                           value="<?= e($editDrug['manufacturer'] ?? '') ?>">
                </div>

                <div class="form-group">
                    <label for="quantity">Quantity *</label>
                    <input type="number" id="quantity" name="quantity" class="form-control"
                           value="<?= e($editDrug['quantity'] ?? '0') ?>" required min="0">
                </div>

                <div class="form-group">
                    <label for="reorder_level">Reorder Level *</label>
                    <input type="number" id="reorder_level" name="reorder_level" class="form-control"
                           value="<?= e($editDrug['reorder_level'] ?? '10') ?>" required min="0">
                </div>

                <div class="form-group">
                    <label for="unit_price">Unit Price ($) *</label>
                    <input type="number" id="unit_price" name="unit_price" class="form-control"
                           value="<?= e($editDrug['unit_price'] ?? '') ?>" required step="0.01" min="0">
                </div>

                <div class="form-group">
                    <label for="expiry_date">Expiry Date</label>
                    <input type="date" id="expiry_date" name="expiry_date" class="form-control"
                           value="<?= e($editDrug['expiry_date'] ?? '') ?>">
                </div>

                <?php if ($subAction === 'edit'): ?>
                    <div class="form-group">
                        <label for="status">Status</label>
                        <select id="status" name="status" class="form-control">
                            <option value="active" <?= ($editDrug['status'] ?? '') === 'active' ? 'selected' : '' ?>>Active</option>
                            <option value="inactive" <?= ($editDrug['status'] ?? '') === 'inactive' ? 'selected' : '' ?>>Inactive</option>
                        </select>
                    </div>
                <?php endif; ?>
            </div>

            <div style="display: flex; gap: 1rem; margin-top: 1.5rem;">
                <button type="submit" name="<?= $subAction === 'edit' ? 'update_drug' : 'add_drug' ?>" class="btn btn-primary">
                    <?= $subAction === 'edit' ? 'Update Drug' : 'Add Drug' ?>
                </button>
                <a href="?action=pharmacy" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
<?php else: ?>
    <!-- Drug Inventory List -->
    <div class="card">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem; flex-wrap: wrap; gap: 1rem;">
            <h2>Drug Inventory (<?= count($inventory) ?>)</h2>
            <a href="?action=pharmacy&sub=add" class="btn btn-primary">+ Add New Drug</a>
        </div>

        <?php if (count($inventory) > 0): ?>
            <div style="overflow-x: auto;">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Drug Code</th>
                            <th>Drug Name</th>
                            <th>Generic Name</th>
                            <th>Category</th>
                            <th>Strength/Form</th>
                            <th>Quantity</th>
                            <th>Unit Price</th>
                            <th>Total Value</th>
                            <th>Expiry Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($inventory as $drug): ?>
                            <tr>
                                <td><strong><?= e($drug['drug_code']) ?></strong></td>
                                <td><?= e($drug['drug_name']) ?></td>
                                <td><?= e($drug['generic_name'] ?? 'N/A') ?></td>
                                <td><?= e($drug['category'] ?? 'N/A') ?></td>
                                <td><?= e($drug['strength']) ?> <?= e($drug['dosage_form']) ?></td>
                                <td>
                                    <span style="color: <?= $drug['quantity'] <= $drug['reorder_level'] ? 'var(--danger-color)' : 'var(--success-color)' ?>;">
                                        <strong><?= $drug['quantity'] ?></strong>
                                    </span>
                                    <br><small style="color: var(--text-light);">Reorder: <?= $drug['reorder_level'] ?></small>
                                </td>
                                <td><?= formatCurrency($drug['unit_price']) ?></td>
                                <td><strong><?= formatCurrency($drug['quantity'] * $drug['unit_price']) ?></strong></td>
                                <td><?= $drug['expiry_date'] ? e(date('M j, Y', strtotime($drug['expiry_date']))) : 'N/A' ?></td>
                                <td>
                                    <span style="padding: 0.25rem 0.75rem; border-radius: 4px; font-size: 0.875rem;
                                        background-color: <?= $drug['status'] === 'active' ? '#d1fae5' : '#fee2e2' ?>;
                                        color: <?= $drug['status'] === 'active' ? '#065f46' : '#991b1b' ?>;">
                                        <?= e(ucfirst($drug['status'])) ?>
                                    </span>
                                </td>
                                <td>
                                    <div style="display: flex; gap: 0.5rem; flex-wrap: wrap;">
                                        <a href="?action=pharmacy&sub=edit&id=<?= $drug['id'] ?>" class="btn btn-secondary" style="padding: 0.5rem 1rem; font-size: 0.875rem;">Edit</a>
                                        <form method="POST" action="?action=pharmacy" style="display: inline;">
                                            <input type="hidden" name="drug_id" value="<?= $drug['id'] ?>">
                                            <button type="submit" name="delete_drug" class="btn btn-danger" style="padding: 0.5rem 1rem; font-size: 0.875rem;"
                                                    onclick="return confirm('Are you sure you want to delete this drug?')">
                                                Delete
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p style="text-align: center; padding: 3rem; color: var(--text-light);">
                No drugs in inventory yet. Click "Add New Drug" to get started.
            </p>
        <?php endif; ?>
    </div>
<?php endif; ?>
