<?php
$db = Database::getInstance()->getConnection();
$userId = $_SESSION['user_id'];

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['update_profile'])) {
        $stmt = $db->prepare("
            UPDATE users SET
                full_name = ?, email = ?, phone = ?
            WHERE id = ?
        ");

        $stmt->execute([
            $_POST['full_name'],
            $_POST['email'],
            $_POST['phone'],
            $userId
        ]);

        // Update session
        $_SESSION['full_name'] = $_POST['full_name'];
        $message = 'Profile updated successfully!';
    } elseif (isset($_POST['change_password'])) {
        // Get current user
        $stmt = $db->prepare("SELECT password FROM users WHERE id = ?");
        $stmt->execute([$userId]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        // Verify current password
        if (password_verify($_POST['current_password'], $user['password'])) {
            // Check if new passwords match
            if ($_POST['new_password'] === $_POST['confirm_password']) {
                if (strlen($_POST['new_password']) >= 6) {
                    $hashedPassword = password_hash($_POST['new_password'], PASSWORD_DEFAULT);

                    $stmt = $db->prepare("UPDATE users SET password = ? WHERE id = ?");
                    $stmt->execute([$hashedPassword, $userId]);

                    $message = 'Password changed successfully!';
                } else {
                    $error = 'New password must be at least 6 characters long.';
                }
            } else {
                $error = 'New passwords do not match.';
            }
        } else {
            $error = 'Current password is incorrect.';
        }
    }
}

// Get user profile
$stmt = $db->prepare("
    SELECT u.*, t.name as hospital_name
    FROM users u
    LEFT JOIN tenants t ON u.tenant_id = t.id
    WHERE u.id = ?
");
$stmt->execute([$userId]);
$userProfile = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<div class="hero">
    <h1>My Profile</h1>
    <p>Manage your account settings and change your password</p>
</div>

<?php
// Check if user is using default password (should change password)
$usingDefaultPassword = false;
$defaultPasswords = [
    'superadmin' => 'superadmin123',
    'admin' => 'admin123',
    'doctor1' => 'doctor123',
    'pharmacist1' => 'pharm123',
    'nurse' => 'nurse123',
    'lab_scientist' => 'lab123',
    'lab_technician' => 'labtech123',
    'pharmacy_technician' => 'pharmtech123',
    'accountant' => 'account123',
    'record_manager' => 'record123',
    'receptionist' => 'reception123',
    'cook' => 'cook123',
    'cleaner' => 'clean123',
    'admin_staff' => 'adminstaff123'
];

if (isset($defaultPasswords[$userProfile['username']])) {
    $usingDefaultPassword = password_verify($defaultPasswords[$userProfile['username']], $userProfile['password']);
}

if ($usingDefaultPassword):
?>
    <div class="alert alert-error" style="border: 2px solid #991b1b; border-left: 6px solid #991b1b;">
        <h3 style="margin-top: 0;">⚠️ Security Alert: You are using a default password!</h3>
        <p><strong>For your account security, you must change your password immediately.</strong></p>
        <p>Your current password is: <code style="background: #fee2e2; padding: 0.25rem 0.5rem; border-radius: 4px;"><?= e($defaultPasswords[$userProfile['username']]) ?></code></p>
        <p>Please use the "Change Password" form below to set a new, secure password.</p>
    </div>
<?php endif; ?>

<?php if (isset($message)): ?>
    <div class="alert alert-success"><?= e($message) ?></div>
<?php endif; ?>

<?php if (isset($error)): ?>
    <div class="alert alert-error"><?= e($error) ?></div>
<?php endif; ?>

<div class="grid">
    <!-- Profile Information -->
    <div class="card">
        <h2>Profile Information</h2>
        <form method="POST" action="?action=profile">
            <div class="form-group">
                <label for="username">Username</label>
                <input type="text" id="username" class="form-control" value="<?= e($userProfile['username']) ?>" readonly>
                <small style="color: var(--text-light);">Username cannot be changed</small>
            </div>

            <div class="form-group">
                <label for="employee_number">Employee Number</label>
                <input type="text" id="employee_number" class="form-control" value="<?= e($userProfile['employee_number'] ?? 'N/A') ?>" readonly>
            </div>

            <div class="form-group">
                <label for="role">Role</label>
                <input type="text" id="role" class="form-control" value="<?= e(getRoleName($userProfile['role'])) ?>" readonly>
            </div>

            <?php if ($userProfile['hospital_name']): ?>
                <div class="form-group">
                    <label for="hospital">Hospital</label>
                    <input type="text" id="hospital" class="form-control" value="<?= e($userProfile['hospital_name']) ?>" readonly>
                </div>
            <?php endif; ?>

            <div class="form-group">
                <label for="full_name">Full Name *</label>
                <input type="text" id="full_name" name="full_name" class="form-control"
                       value="<?= e($userProfile['full_name']) ?>" required>
            </div>

            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" id="email" name="email" class="form-control"
                       value="<?= e($userProfile['email'] ?? '') ?>">
            </div>

            <div class="form-group">
                <label for="phone">Phone</label>
                <input type="tel" id="phone" name="phone" class="form-control"
                       value="<?= e($userProfile['phone'] ?? '') ?>">
            </div>

            <button type="submit" name="update_profile" class="btn btn-primary btn-block">Update Profile</button>
        </form>
    </div>

    <!-- Change Password -->
    <div class="card">
        <h2>Change Password</h2>
        <form method="POST" action="?action=profile">
            <div class="form-group">
                <label for="current_password">Current Password *</label>
                <input type="password" id="current_password" name="current_password" class="form-control" required>
            </div>

            <div class="form-group">
                <label for="new_password">New Password *</label>
                <input type="password" id="new_password" name="new_password" class="form-control" required minlength="6">
                <small style="color: var(--text-light);">Minimum 6 characters</small>
            </div>

            <div class="form-group">
                <label for="confirm_password">Confirm New Password *</label>
                <input type="password" id="confirm_password" name="confirm_password" class="form-control" required minlength="6">
            </div>

            <button type="submit" name="change_password" class="btn btn-primary btn-block">Change Password</button>
        </form>

        <div style="margin-top: 2rem; padding: 1rem; background: var(--light-color); border-radius: 8px;">
            <strong>Password Requirements:</strong>
            <ul style="margin-left: 1.5rem; line-height: 2; color: var(--text-dark);">
                <li>At least 6 characters long</li>
                <li>Must enter current password correctly</li>
                <li>New password and confirmation must match</li>
            </ul>
        </div>
    </div>
</div>

<!-- Account Details -->
<div class="card">
    <h2>Account Details</h2>
    <div class="grid">
        <div>
            <p><strong>Account Status:</strong>
                <span style="padding: 0.25rem 0.75rem; border-radius: 4px; font-size: 0.875rem; margin-left: 0.5rem;
                    background-color: <?= $userProfile['status'] === 'active' ? '#d1fae5' : '#fee2e2' ?>;
                    color: <?= $userProfile['status'] === 'active' ? '#065f46' : '#991b1b' ?>;">
                    <?= e(ucfirst($userProfile['status'])) ?>
                </span>
            </p>
            <p><strong>Member Since:</strong> <?= e(date('F j, Y', strtotime($userProfile['created_at']))) ?></p>
        </div>
        <div>
            <?php if ($userProfile['department']): ?>
                <p><strong>Department:</strong> <?= e($userProfile['department']) ?></p>
            <?php endif; ?>
            <p><strong>Last Activity:</strong> <?= e(isset($_SESSION['last_activity']) && $_SESSION['last_activity'] && is_numeric($_SESSION['last_activity']) ? date('F j, Y g:i A', $_SESSION['last_activity']) : date('F j, Y g:i A')) ?></p>
        </div>
    </div>
</div>
