<?php
// Receipt Printing Page
$db = Database::getInstance()->getConnection();
$tenantId = $_SESSION['tenant_id'];

if (!isset($_GET['id'])) {
    header('Location: ?action=billing');
    exit;
}

// Get billing details
$stmt = $db->prepare("
    SELECT b.*, p.full_name as patient_name, p.patient_number, p.phone, p.address,
           t.name as hospital_name, t.address as hospital_address, t.phone as hospital_phone, t.email as hospital_email
    FROM billing b
    JOIN patients p ON b.patient_id = p.id
    JOIN tenants t ON b.tenant_id = t.id
    WHERE b.id = ? AND b.tenant_id = ?
");
$stmt->execute([$_GET['id'], $tenantId]);
$bill = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$bill) {
    header('Location: ?action=billing');
    exit;
}

// Get tenant details
$tenantStmt = $db->prepare("SELECT * FROM tenants WHERE id = ?");
$tenantStmt->execute([$tenantId]);
$tenant = $tenantStmt->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Receipt - <?= e($bill['invoice_number']) ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Courier New', Courier, monospace;
            font-size: 14px;
            line-height: 1.4;
            background: #f5f5f5;
            padding: 20px;
        }

        .receipt {
            max-width: 80mm;
            margin: 0 auto;
            background: white;
            padding: 10mm;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .receipt-header {
            text-align: center;
            border-bottom: 2px dashed #000;
            padding-bottom: 10px;
            margin-bottom: 15px;
        }

        .receipt-header h1 {
            font-size: 18px;
            margin-bottom: 5px;
        }

        .receipt-header p {
            font-size: 11px;
            margin: 2px 0;
        }

        .receipt-title {
            text-align: center;
            font-size: 16px;
            font-weight: bold;
            margin: 15px 0;
            text-decoration: underline;
        }

        .receipt-info {
            margin-bottom: 15px;
        }

        .receipt-info p {
            margin: 3px 0;
            display: flex;
            justify-content: space-between;
        }

        .receipt-info strong {
            font-weight: bold;
        }

        .receipt-items {
            border-top: 1px dashed #000;
            border-bottom: 1px dashed #000;
            padding: 10px 0;
            margin-bottom: 15px;
        }

        .receipt-item {
            display: flex;
            justify-content: space-between;
            margin: 5px 0;
        }

        .receipt-total {
            text-align: right;
            font-size: 16px;
            font-weight: bold;
            margin-top: 10px;
            padding-top: 10px;
            border-top: 2px solid #000;
        }

        .payment-info {
            margin-top: 15px;
            padding-top: 10px;
            border-top: 1px dashed #000;
        }

        .payment-info p {
            margin: 3px 0;
        }

        .receipt-footer {
            text-align: center;
            margin-top: 20px;
            padding-top: 10px;
            border-top: 1px dashed #000;
            font-size: 11px;
        }

        .receipt-footer p {
            margin: 3px 0;
        }

        .status-paid {
            color: #065f46;
            font-weight: bold;
        }

        .status-pending {
            color: #991b1b;
            font-weight: bold;
        }

        .no-print {
            text-align: center;
            margin: 20px 0;
        }

        .no-print button,
        .no-print a {
            padding: 10px 20px;
            margin: 0 5px;
            font-size: 14px;
            cursor: pointer;
            border: none;
            border-radius: 5px;
            text-decoration: none;
            display: inline-block;
        }

        .btn-print {
            background: #4f46e5;
            color: white;
        }

        .btn-back {
            background: #6b7280;
            color: white;
        }

        @media print {
            body {
                background: white;
                padding: 0;
            }

            .receipt {
                box-shadow: none;
                max-width: 100%;
                padding: 0;
            }

            .no-print {
                display: none;
            }

            @page {
                size: 80mm auto;
                margin: 0;
            }
        }
    </style>
</head>
<body>
    <div class="receipt">
        <div class="receipt-header">
            <h1><?= e($tenant['name']) ?></h1>
            <p><?= e($tenant['address']) ?></p>
            <p><?= e($tenant['phone']) ?></p>
            <?php if ($tenant['email']): ?>
                <p><?= e($tenant['email']) ?></p>
            <?php endif; ?>
        </div>

        <div class="receipt-title">OFFICIAL RECEIPT</div>

        <div class="receipt-info">
            <p><strong>Receipt No:</strong> <span><?= e($bill['invoice_number']) ?></span></p>
            <p><strong>Date:</strong> <span><?= e(date('M j, Y g:i A', strtotime($bill['created_at']))) ?></span></p>
            <?php if ($bill['payment_date']): ?>
                <p><strong>Payment Date:</strong> <span><?= e(date('M j, Y g:i A', strtotime($bill['payment_date']))) ?></span></p>
            <?php endif; ?>
        </div>

        <div class="receipt-info">
            <p><strong>Patient:</strong> <span><?= e($bill['patient_name']) ?></span></p>
            <p><strong>Patient No:</strong> <span><?= e($bill['patient_number']) ?></span></p>
        </div>

        <div class="receipt-items">
            <div class="receipt-item">
                <span><strong>Description</strong></span>
                <span><strong>Amount</strong></span>
            </div>
            <div class="receipt-item">
                <span><?= e($bill['description']) ?></span>
                <span><?= formatCurrency($bill['amount']) ?></span>
            </div>
        </div>

        <div class="receipt-total">
            TOTAL: <?= formatCurrency($bill['amount']) ?>
        </div>

        <?php if ($bill['payment_status'] === 'paid'): ?>
            <div class="payment-info">
                <p><strong>Payment Status:</strong> <span class="status-paid">PAID</span></p>
                <p><strong>Payment Method:</strong> <span><?= e(ucfirst($bill['payment_method'] ?? 'N/A')) ?></span></p>
                <p><strong>Payment Date:</strong> <span><?= e(date('M j, Y g:i A', strtotime($bill['payment_date']))) ?></span></p>
            </div>
        <?php else: ?>
            <div class="payment-info">
                <p><strong>Payment Status:</strong> <span class="status-pending">PENDING</span></p>
            </div>
        <?php endif; ?>

        <div class="receipt-footer">
            <p><strong><?= e($tenant['name']) ?></strong></p>
            <p>Thank you for your payment!</p>
            <p><?= e(date('Y-m-d H:i:s')) ?></p>
        </div>
    </div>

    <div class="no-print">
        <button onclick="window.print()" class="btn-print">Print Receipt</button>
        <a href="?action=billing" class="btn-back">Back to Billing</a>
    </div>
</body>
</html>
