<?php
// Handle hospital registration
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['register_hospital'])) {
    $db = Database::getInstance()->getConnection();

    // Validate subdomain (alphanumeric and hyphens only)
    $subdomain = preg_replace('/[^a-z0-9-]/', '', strtolower($_POST['subdomain']));

    // Check if subdomain already exists
    $stmt = $db->prepare("SELECT COUNT(*) FROM tenants WHERE subdomain = ?");
    $stmt->execute([$subdomain]);

    if ($stmt->fetchColumn() > 0) {
        $error = 'This subdomain is already taken. Please choose another one.';
    } else {
        try {
            $db->beginTransaction();

            // Insert new tenant
            $stmt = $db->prepare("
                INSERT INTO tenants (name, subdomain, address, phone, email, license_number, status)
                VALUES (?, ?, ?, ?, ?, ?, 'pending')
            ");

            $stmt->execute([
                $_POST['hospital_name'],
                $subdomain,
                $_POST['address'],
                $_POST['phone'],
                $_POST['email'],
                $_POST['license_number']
            ]);

            $db->commit();
            $message = 'Hospital registration submitted successfully! Please wait for Super Admin approval. Your subdomain: ' . $subdomain;
            $subAction = 'success';
        } catch (Exception $e) {
            $db->rollBack();
            $error = 'Registration failed: ' . $e->getMessage();
        }
    }
}
?>

<div class="hero">
    <h1>Hospital Registration</h1>
    <p>Register your hospital to use our comprehensive management system</p>
</div>

<?php if (isset($message)): ?>
    <div class="alert alert-success">
        <?= e($message) ?>
        <div style="margin-top: 1rem;">
            <a href="?action=home" class="btn btn-primary">Back to Home</a>
        </div>
    </div>
<?php elseif (isset($subAction) && $subAction === 'success'): ?>
    <!-- Already handled above -->
<?php else: ?>
    <?php if (isset($error)): ?>
        <div class="alert alert-error"><?= e($error) ?></div>
    <?php endif; ?>

    <div class="card">
        <h2>Register Your Hospital</h2>
        <p style="margin-bottom: 1.5rem; color: var(--text-light);">
            Fill out the form below to register your hospital. Once approved by our Super Administrator,
            you'll receive access credentials to start managing your hospital.
        </p>

        <form method="POST" action="?action=register_hospital">
            <div class="grid">
                <div class="form-group">
                    <label for="hospital_name">Hospital Name *</label>
                    <input type="text" id="hospital_name" name="hospital_name" class="form-control"
                           required placeholder="e.g., City General Hospital">
                </div>

                <div class="form-group">
                    <label for="subdomain">Subdomain * <small style="color: var(--text-light);">(will be used for identification)</small></label>
                    <input type="text" id="subdomain" name="subdomain" class="form-control"
                           required pattern="[a-z0-9-]+" placeholder="e.g., citygeneralhospital"
                           onkeyup="this.value = this.value.toLowerCase().replace(/[^a-z0-9-]/g, '')">
                    <small style="color: var(--text-light);">Only lowercase letters, numbers, and hyphens allowed</small>
                </div>

                <div class="form-group">
                    <label for="license_number">Hospital License Number *</label>
                    <input type="text" id="license_number" name="license_number" class="form-control"
                           required placeholder="e.g., HL-2025-12345">
                </div>

                <div class="form-group">
                    <label for="phone">Phone Number *</label>
                    <input type="tel" id="phone" name="phone" class="form-control"
                           required placeholder="+1-555-0100">
                </div>

                <div class="form-group">
                    <label for="email">Email Address *</label>
                    <input type="email" id="email" name="email" class="form-control"
                           required placeholder="info@yourhospital.com">
                </div>
            </div>

            <div class="form-group">
                <label for="address">Hospital Address *</label>
                <textarea id="address" name="address" class="form-control" rows="3"
                          required placeholder="Enter complete hospital address"></textarea>
            </div>

            <div style="background: var(--light-color); padding: 1rem; border-radius: 8px; margin-bottom: 1.5rem;">
                <h3 style="font-size: 1rem; margin-bottom: 0.5rem;">What happens next?</h3>
                <ol style="margin-left: 1.5rem; line-height: 2;">
                    <li>Your registration will be reviewed by our Super Administrator</li>
                    <li>Once approved, a Hospital Admin account will be created for you</li>
                    <li>You'll receive login credentials via email</li>
                    <li>You can then start adding users and managing your hospital</li>
                </ol>
            </div>

            <div style="display: flex; gap: 1rem; flex-wrap: wrap;">
                <button type="submit" name="register_hospital" class="btn btn-primary">Submit Registration</button>
                <a href="?action=home" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>

    <!-- Features -->
    <div class="card">
        <h2>What You'll Get</h2>
        <div class="grid">
            <div class="feature-card">
                <div class="feature-icon">U</div>
                <h3>User Management</h3>
                <p>Create and manage users: doctors, nurses, pharmacists, lab staff, and more</p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">P</div>
                <h3>Patient Care</h3>
                <p>Comprehensive patient management, appointments, and admissions</p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">L</div>
                <h3>Laboratory</h3>
                <p>Manage lab tests, orders, and results efficiently</p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">R</div>
                <h3>Pharmacy</h3>
                <p>Inventory management, dispensing, and stock tracking</p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">A</div>
                <h3>Accounting</h3>
                <p>Financial tracking, billing, and transaction management</p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">M</div>
                <h3>More Modules</h3>
                <p>Restaurant, attendance, medical records, and reports</p>
            </div>
        </div>
    </div>
<?php endif; ?>
