<?php
$db = Database::getInstance()->getConnection();
$tenantId = $_SESSION['tenant_id'];

// Get restaurant orders
$orders = $db->query("
    SELECT ro.*, p.full_name as patient_name, p.patient_number, rm.item_name, u1.full_name as prepared_by_name, u2.full_name as delivered_by_name
    FROM restaurant_orders ro
    JOIN restaurant_menu rm ON ro.menu_item_id = rm.id
    LEFT JOIN patients p ON ro.patient_id = p.id
    LEFT JOIN users u1 ON ro.prepared_by = u1.id
    LEFT JOIN users u2 ON ro.delivered_by = u2.id
    WHERE ro.tenant_id = $tenantId
    ORDER BY ro.order_date DESC
")->fetchAll(PDO::FETCH_ASSOC);

// Get menu items
$menuItems = $db->query("SELECT * FROM restaurant_menu WHERE tenant_id = $tenantId ORDER BY category, item_name")->fetchAll(PDO::FETCH_ASSOC);

// Statistics
$stats = [
    'total_orders' => count($orders),
    'pending' => $db->query("SELECT COUNT(*) FROM restaurant_orders WHERE tenant_id = $tenantId AND status = 'pending'")->fetchColumn(),
    'delivered' => $db->query("SELECT COUNT(*) FROM restaurant_orders WHERE tenant_id = $tenantId AND status = 'delivered'")->fetchColumn(),
];
?>

<div class="hero">
    <h1>Restaurant/Catering Management</h1>
    <p>Manage meal orders and menu</p>
</div>

<div class="stats">
    <div class="stat-card">
        <div class="stat-value"><?= $stats['total_orders'] ?></div>
        <div class="stat-label">Total Orders</div>
    </div>
    <div class="stat-card warning">
        <div class="stat-value"><?= $stats['pending'] ?></div>
        <div class="stat-label">Pending Orders</div>
    </div>
    <div class="stat-card success">
        <div class="stat-value"><?= $stats['delivered'] ?></div>
        <div class="stat-label">Delivered</div>
    </div>
</div>

<div class="card">
    <h2>Menu Items</h2>
    <div class="grid">
        <?php foreach ($menuItems as $item): ?>
            <div class="card" style="border-left: 4px solid var(--success-color);">
                <h3 style="margin-bottom: 0.5rem;"><?= e($item['item_name']) ?></h3>
                <p style="color: var(--text-light); font-size: 0.875rem; margin-bottom: 0.5rem;"><?= e($item['item_code']) ?> | <?= e($item['category']) ?></p>
                <p style="margin-bottom: 0.75rem;"><?= e($item['description']) ?></p>
                <p><strong>Price:</strong> <?= formatCurrency($item['unit_price']) ?></p>
                <p style="font-size: 0.875rem; color: var(--text-light);"><?= e($item['dietary_info'] ?? 'N/A') ?></p>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<div class="card">
    <h2>Recent Orders</h2>
    <div style="overflow-x: auto;">
        <table class="table">
            <thead>
                <tr>
                    <th>Order #</th>
                    <th>Patient</th>
                    <th>Item</th>
                    <th>Quantity</th>
                    <th>Total</th>
                    <th>Order Date</th>
                    <th>Room</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($orders as $order): ?>
                    <tr>
                        <td><strong><?= e($order['order_number']) ?></strong></td>
                        <td><?= e($order['patient_name'] ?? 'Staff Order') ?></td>
                        <td><?= e($order['item_name']) ?></td>
                        <td><?= $order['quantity'] ?></td>
                        <td><?= formatCurrency($order['total_price']) ?></td>
                        <td><?= e(date('M j, Y g:i A', strtotime($order['order_date']))) ?></td>
                        <td><?= e($order['room_number'] ?? 'N/A') ?></td>
                        <td>
                            <span style="padding: 0.25rem 0.75rem; border-radius: 4px; font-size: 0.875rem;
                                background-color: <?= $order['status'] === 'delivered' ? '#d1fae5' : ($order['status'] === 'pending' ? '#fef3c7' : '#dbeafe') ?>;
                                color: <?= $order['status'] === 'delivered' ? '#065f46' : ($order['status'] === 'pending' ? '#92400e' : '#1e40af') ?>;">
                                <?= e(ucfirst($order['status'])) ?>
                            </span>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
