<?php
$db = Database::getInstance()->getConnection();
$tenantId = $_SESSION['tenant_id'];
$userId = $_SESSION['user_id'];
$userRole = $_SESSION['role'];

// Check if user can access restaurant orders
$canAccessRestaurant = in_array($userRole, ['hospital_admin', 'cook', 'receptionist']);

if (!$canAccessRestaurant) {
    header('Location: ?action=dashboard');
    exit;
}

$subAction = $_GET['sub'] ?? 'new';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['create_order'])) {
        // Create restaurant order
        $orderNumber = 'FOOD' . date('Ymd') . str_pad($db->query("SELECT COUNT(*) FROM restaurant_orders WHERE tenant_id = $tenantId")->fetchColumn() + 1, 4, '0', STR_PAD_LEFT);

        $stmt = $db->prepare("
            INSERT INTO restaurant_orders (tenant_id, patient_id, order_number, meal_items, total_amount, notes, ordered_by)
            VALUES (?, ?, ?, ?, ?, ?, ?)
        ");

        $stmt->execute([
            $tenantId,
            $_POST['patient_id'],
            $orderNumber,
            $_POST['meal_items'],
            $_POST['total_amount'],
            $_POST['notes'] ?? '',
            $userId
        ]);

        $orderId = $db->lastInsertId();

        // Generate invoice immediately
        $invoiceNumber = 'INV' . date('Ymd') . str_pad($db->query("SELECT COUNT(*) FROM billing WHERE tenant_id = $tenantId")->fetchColumn() + 1, 4, '0', STR_PAD_LEFT);

        // Get patient name for description
        $patientStmt = $db->prepare("SELECT full_name FROM patients WHERE id = ?");
        $patientStmt->execute([$_POST['patient_id']]);
        $patientName = $patientStmt->fetchColumn();

        $description = "Restaurant - Order #{$orderNumber}: {$_POST['meal_items']}";

        $stmt = $db->prepare("
            INSERT INTO billing (tenant_id, patient_id, invoice_number, description, amount, payment_status)
            VALUES (?, ?, ?, ?, ?, 'pending')
        ");
        $stmt->execute([
            $tenantId,
            $_POST['patient_id'],
            $invoiceNumber,
            $description,
            $_POST['total_amount']
        ]);

        $invoiceId = $db->lastInsertId();

        // Update order with invoice ID
        $updateStmt = $db->prepare("
            UPDATE restaurant_orders
            SET invoice_id = ?, status = 'invoiced'
            WHERE id = ?
        ");
        $updateStmt->execute([$invoiceId, $orderId]);

        $message = "Order created successfully! Invoice {$invoiceNumber} generated for " . formatCurrency($_POST['total_amount']);
    }
}

// Patient search for ordering
$searchResults = [];
$selectedPatient = null;

if (isset($_GET['search']) && !empty($_GET['search_query'])) {
    $searchQuery = '%' . $_GET['search_query'] . '%';
    $stmt = $db->prepare("
        SELECT * FROM patients
        WHERE tenant_id = ? AND (patient_number LIKE ? OR full_name LIKE ?)
        ORDER BY full_name
        LIMIT 20
    ");
    $stmt->execute([$tenantId, $searchQuery, $searchQuery]);
    $searchResults = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Get patient details if selected
if ($subAction === 'order' && isset($_GET['patient_id'])) {
    $stmt = $db->prepare("SELECT * FROM patients WHERE id = ? AND tenant_id = ?");
    $stmt->execute([$_GET['patient_id'], $tenantId]);
    $selectedPatient = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($selectedPatient) {
        // Get restaurant menu items
        $menuItems = $db->query("SELECT * FROM restaurant_menu WHERE tenant_id = $tenantId ORDER BY item_name")->fetchAll(PDO::FETCH_ASSOC);
    }
}

// View orders
$recentOrders = $db->query("
    SELECT ro.*, p.full_name as patient_name, p.patient_number
    FROM restaurant_orders ro
    JOIN patients p ON ro.patient_id = p.id
    WHERE ro.tenant_id = $tenantId
    ORDER BY ro.created_at DESC
    LIMIT 50
")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="hero">
    <h1>Restaurant Orders</h1>
    <p>Create meal orders for patients and generate invoices</p>
</div>

<?php if (isset($message)): ?>
    <div class="alert alert-success"><?= e($message) ?></div>
<?php endif; ?>

<?php if ($subAction === 'new' || $subAction === 'search'): ?>
    <!-- Patient Search -->
    <div class="card">
        <h2>Create New Order</h2>
        <p style="color: var(--text-dark); margin-bottom: 1.5rem;">
            Search for patient to create meal order.
        </p>

        <form method="GET" action="?action=restaurant_orders">
            <input type="hidden" name="action" value="restaurant_orders">
            <input type="hidden" name="search" value="1">

            <div style="display: flex; gap: 1rem; flex-wrap: wrap;">
                <div style="flex: 1; min-width: 300px;">
                    <input type="text" name="search_query" class="form-control"
                           placeholder="Enter patient number or name"
                           value="<?= e($_GET['search_query'] ?? '') ?>" required>
                </div>
                <button type="submit" class="btn btn-primary">Search Patient</button>
            </div>
        </form>
    </div>

    <?php if (count($searchResults) > 0): ?>
        <!-- Search Results -->
        <div class="card">
            <h2>Search Results (<?= count($searchResults) ?>)</h2>
            <div style="overflow-x: auto;">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Patient #</th>
                            <th>Full Name</th>
                            <th>Phone</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($searchResults as $patient): ?>
                            <tr>
                                <td><strong><?= e($patient['patient_number']) ?></strong></td>
                                <td><?= e($patient['full_name']) ?></td>
                                <td><?= e($patient['phone'] ?? 'N/A') ?></td>
                                <td>
                                    <a href="?action=restaurant_orders&sub=order&patient_id=<?= $patient['id'] ?>" class="btn btn-primary" style="padding: 0.5rem 1rem; font-size: 0.875rem;">
                                        Create Order
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php elseif (isset($_GET['search'])): ?>
        <div class="card">
            <p style="text-align: center; padding: 2rem; color: var(--text-light);">
                No patients found matching your search.
            </p>
        </div>
    <?php endif; ?>

    <!-- Recent Orders -->
    <div class="card">
        <h2>Recent Orders</h2>

        <?php if (count($recentOrders) > 0): ?>
            <div style="overflow-x: auto;">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Order #</th>
                            <th>Patient</th>
                            <th>Meal Items</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($recentOrders as $order): ?>
                            <tr>
                                <td><?= e($order['order_number']) ?></td>
                                <td><?= e($order['patient_name']) ?></td>
                                <td><?= e($order['meal_items']) ?></td>
                                <td><?= formatCurrency($order['total_amount']) ?></td>
                                <td>
                                    <span style="padding: 0.25rem 0.75rem; border-radius: 4px; font-size: 0.875rem;
                                        background-color: <?= $order['status'] === 'pending' ? '#fef3c7' : '#d1fae5' ?>;
                                        color: <?= $order['status'] === 'pending' ? '#92400e' : '#065f46' ?>;">
                                        <?= ucfirst($order['status']) ?>
                                    </span>
                                </td>
                                <td><?= e(date('M j, Y g:i A', strtotime($order['created_at']))) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p style="text-align: center; padding: 2rem; color: var(--text-light);">
                No orders yet.
            </p>
        <?php endif; ?>
    </div>

<?php elseif ($subAction === 'order' && $selectedPatient): ?>
    <!-- Create Order Form -->
    <div class="card">
        <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 1rem; margin-bottom: 1.5rem;">
            <h2>Create Meal Order</h2>
            <a href="?action=restaurant_orders" class="btn btn-secondary">← Back</a>
        </div>

        <!-- Patient Info -->
        <div style="background: var(--light-color); padding: 1.5rem; border-radius: 8px; margin-bottom: 2rem;">
            <h3 style="margin-top: 0;">Patient Information</h3>
            <div class="grid">
                <div>
                    <p><strong>Patient Number:</strong> <?= e($selectedPatient['patient_number']) ?></p>
                    <p><strong>Full Name:</strong> <?= e($selectedPatient['full_name']) ?></p>
                </div>
                <div>
                    <p><strong>Phone:</strong> <?= e($selectedPatient['phone'] ?? 'N/A') ?></p>
                </div>
            </div>
        </div>

        <!-- Order Form -->
        <form method="POST" action="?action=restaurant_orders">
            <input type="hidden" name="patient_id" value="<?= $selectedPatient['id'] ?>">

            <?php if (count($menuItems) > 0): ?>
                <h3>Select Meal Items</h3>

                <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(280px, 1fr)); gap: 1rem; margin-bottom: 1.5rem;">
                    <?php foreach ($menuItems as $item): ?>
                        <label style="display: flex; align-items: center; gap: 0.75rem; padding: 1rem; background: var(--light-color); border-radius: 8px; cursor: pointer; border: 2px solid transparent;" onmouseover="this.style.borderColor='var(--primary-color)'" onmouseout="this.style.borderColor='transparent'">
                            <input type="checkbox" name="menu_items[]" value="<?= $item['id'] ?>"
                                   data-item="<?= e($item['item_name']) ?>"
                                   data-price="<?= $item['price'] ?>"
                                   onchange="updateOrderTotal()">
                            <div style="flex: 1;">
                                <strong><?= e($item['item_name']) ?></strong>
                                <div style="color: var(--text-dark); font-size: 0.875rem;"><?= e($item['description'] ?? '') ?></div>
                                <div style="color: var(--primary-color); font-weight: bold; margin-top: 0.25rem;"><?= formatCurrency($item['price']) ?></div>
                            </div>
                        </label>
                    <?php endforeach; ?>
                </div>

                <div style="background: var(--light-color); padding: 1.5rem; border-radius: 8px; margin-bottom: 2rem;">
                    <h3 style="margin-top: 0;">Order Summary</h3>
                    <div class="grid">
                        <div>
                            <p><strong>Selected Items:</strong></p>
                            <div id="selected-items" style="margin-top: 0.5rem; min-height: 50px; padding: 1rem; background: white; border-radius: 4px; border: 1px solid #ddd;">
                                <em style="color: var(--text-light);">No items selected</em>
                            </div>
                        </div>
                        <div>
                            <p><strong>Total Amount:</strong></p>
                            <div id="order-total" style="font-size: 2rem; font-weight: bold; color: var(--primary-color); margin-top: 0.5rem;">
                                $0.00
                            </div>
                        </div>
                    </div>
                </div>

                <input type="hidden" name="meal_items" id="meal-items-input">
                <input type="hidden" name="total_amount" id="total-amount-input" value="0">

                <div class="form-group">
                    <label for="notes">Order Notes</label>
                    <textarea id="notes" name="notes" class="form-control" rows="2"
                              placeholder="Any special instructions or dietary requirements"></textarea>
                </div>

                <div class="alert alert-info" style="margin-bottom: 1.5rem;">
                    <strong>Note:</strong> An invoice will be generated automatically. The patient will need to pay at accounting before receiving the meal.
                </div>

                <button type="submit" name="create_order" class="btn btn-primary">Create Order & Generate Invoice</button>
            <?php else: ?>
                <div class="alert alert-error">
                    No menu items available. Please add items to the restaurant menu first.
                </div>
            <?php endif; ?>

            <a href="?action=restaurant_orders" class="btn btn-secondary">Cancel</a>
        </form>
    </div>
<?php endif; ?>

<script>
function updateOrderTotal() {
    const checkboxes = document.querySelectorAll('input[name="menu_items[]"]:checked');
    const selectedItemsDiv = document.getElementById('selected-items');
    const orderTotalDiv = document.getElementById('order-total');
    const mealItemsInput = document.getElementById('meal-items-input');
    const totalAmountInput = document.getElementById('total-amount-input');

    let total = 0;
    let items = [];

    if (checkboxes.length === 0) {
        selectedItemsDiv.innerHTML = '<em style="color: var(--text-light);">No items selected</em>';
        orderTotalDiv.textContent = '$0.00';
        mealItemsInput.value = '';
        totalAmountInput.value = '0';
        return;
    }

    checkboxes.forEach(checkbox => {
        const itemName = checkbox.getAttribute('data-item');
        const price = parseFloat(checkbox.getAttribute('data-price'));
        total += price;
        items.push(itemName);
    });

    selectedItemsDiv.innerHTML = items.map(item => `<div style="padding: 0.25rem 0;">• ${item}</div>`).join('');
    orderTotalDiv.textContent = '$' + total.toFixed(2);
    mealItemsInput.value = items.join(', ');
    totalAmountInput.value = total;
}
</script>
