<?php
$db = Database::getInstance()->getConnection();
$tenantId = $_SESSION['tenant_id'];

// Only Hospital Admin can access settings
if ($_SESSION['role'] !== 'hospital_admin') {
    header('Location: ?action=dashboard');
    exit;
}

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['update_settings'])) {
        // Update tenant settings
        $stmt = $db->prepare("
            UPDATE tenants SET
                patient_card_fee = ?,
                email_notifications = ?
            WHERE id = ?
        ");

        $stmt->execute([
            $_POST['patient_card_fee'],
            isset($_POST['email_notifications']) ? 1 : 0,
            $tenantId
        ]);

        $message = 'Settings updated successfully!';
    }
}

// Get current settings
$stmt = $db->prepare("SELECT * FROM tenants WHERE id = ?");
$stmt->execute([$tenantId]);
$settings = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<div class="hero">
    <h1>Hospital Settings</h1>
    <p>Configure your hospital's system settings</p>
</div>

<?php if (isset($message)): ?>
    <div class="alert alert-success"><?= e($message) ?></div>
<?php endif; ?>

<div class="card">
    <h2>General Settings</h2>
    <form method="POST" action="?action=settings">
        <div class="grid">
            <div class="form-group">
                <label for="name">Hospital Name</label>
                <input type="text" id="name" class="form-control" value="<?= e($settings['name']) ?>" readonly>
                <small style="color: var(--text-light);">Contact support to change hospital name</small>
            </div>

            <div class="form-group">
                <label for="subdomain">Subdomain</label>
                <input type="text" id="subdomain" class="form-control" value="<?= e($settings['subdomain']) ?>" readonly>
            </div>

            <div class="form-group">
                <label for="address">Address</label>
                <input type="text" id="address" class="form-control" value="<?= e($settings['address']) ?>" readonly>
            </div>

            <div class="form-group">
                <label for="phone">Phone</label>
                <input type="tel" id="phone" class="form-control" value="<?= e($settings['phone']) ?>" readonly>
            </div>

            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" id="email" class="form-control" value="<?= e($settings['email']) ?>" readonly>
            </div>

            <div class="form-group">
                <label for="license_number">License Number</label>
                <input type="text" id="license_number" class="form-control" value="<?= e($settings['license_number']) ?>" readonly>
            </div>
        </div>
    </form>
</div>

<div class="card">
    <h2>Patient Card Settings</h2>
    <form method="POST" action="?action=settings">
        <div class="form-group">
            <label for="patient_card_fee">Patient Card Fee ($) *</label>
            <input type="number" id="patient_card_fee" name="patient_card_fee" class="form-control"
                   value="<?= e($settings['patient_card_fee'] ?? '5.00') ?>" required step="0.01" min="0">
            <small style="color: var(--text-light);">
                Fee charged when printing patient identification cards. This will be added to billing.
            </small>
        </div>

        <div class="form-group">
            <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                <input type="checkbox" name="email_notifications" value="1"
                       <?= ($settings['email_notifications'] ?? 0) ? 'checked' : '' ?>>
                <span>Enable Email Notifications</span>
            </label>
            <small style="color: var(--text-light);">
                Send patient cards and other notifications via email
            </small>
        </div>

        <button type="submit" name="update_settings" class="btn btn-primary">Update Settings</button>
    </form>
</div>

<div class="card">
    <h2>Account Information</h2>
    <div class="grid">
        <div>
            <p><strong>Account Status:</strong>
                <span style="padding: 0.25rem 0.75rem; border-radius: 4px; font-size: 0.875rem; margin-left: 0.5rem;
                    background-color: <?= $settings['status'] === 'active' ? '#d1fae5' : '#fee2e2' ?>;
                    color: <?= $settings['status'] === 'active' ? '#065f46' : '#991b1b' ?>;">
                    <?= e(ucfirst($settings['status'])) ?>
                </span>
            </p>
            <p><strong>Registered:</strong> <?= e(date('F j, Y', strtotime($settings['created_at']))) ?></p>
        </div>
        <div>
            <p><strong>Plan:</strong> Standard</p>
            <p><strong>Users:</strong>
                <?php
                $userCount = $db->query("SELECT COUNT(*) FROM users WHERE tenant_id = $tenantId")->fetchColumn();
                echo $userCount;
                ?>
            </p>
        </div>
    </div>
</div>
