<div class="hero" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%);">
    <h1>Staff Login - <?= e($currentTenant['name']) ?></h1>
    <p>Access your staff portal to manage patient care and daily operations</p>
</div>

<div class="card" style="max-width: 600px; margin: 2rem auto;">
    <div style="text-align: center; margin-bottom: 2rem;">
        <div style="width: 80px; height: 80px; background: #3b82f6; color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 1rem; font-size: 2rem; font-weight: bold;">S</div>
        <h2 style="color: #1e40af;">Staff Login</h2>
        <p style="color: var(--text-light);">For Doctors, Nurses, Pharmacists, Lab Staff, Accountants, and all hospital employees</p>
    </div>

    <?php if (isset($error)): ?>
        <div class="alert alert-error"><?= e($error) ?></div>
    <?php endif; ?>

    <?php if (!$currentTenant || !isset($currentTenant['id'])): ?>
        <div class="alert alert-error">Error: No hospital selected. Please go back to home page.</div>
    <?php else: ?>
    <form method="POST" action="./index.php?action=staff_login">
        <input type="hidden" name="tenant_id" value="<?= e($currentTenant['id']) ?>">
        <input type="hidden" name="tenant_name" value="<?= e($currentTenant['name']) ?>">

        <div class="form-group">
            <label for="username">Username</label>
            <input type="text" id="username" name="username" class="form-control" placeholder="Enter your username" required autofocus>
        </div>

        <div class="form-group">
            <label for="password">Password</label>
            <input type="password" id="password" name="password" class="form-control" placeholder="Enter your password" required>
        </div>

        <button type="submit" name="login" class="btn btn-primary btn-block" style="background: #3b82f6; font-size: 1.1rem; padding: 1rem;">Login to Staff Portal</button>
    </form>

    <div style="margin-top: 2rem; padding: 1.5rem; background: #dbeafe; border-radius: 8px; border-left: 4px solid #3b82f6;">
        <h3 style="margin-bottom: 1rem; color: #1e40af;">Demo Staff Credentials:</h3>
        <table style="width: 100%; border-collapse: collapse;">
            <tr style="border-bottom: 1px solid #93c5fd;">
                <th style="text-align: left; padding: 8px; color: #1e40af;">Role</th>
                <th style="text-align: left; padding: 8px; color: #1e40af;">Username</th>
                <th style="text-align: left; padding: 8px; color: #1e40af;">Password</th>
            </tr>
            <tr style="border-bottom: 1px solid #bfdbfe;">
                <td style="padding: 8px;">Doctor</td>
                <td style="padding: 8px;"><code>doctor1</code></td>
                <td style="padding: 8px;"><code>doctor123</code></td>
            </tr>
            <tr style="border-bottom: 1px solid #bfdbfe;">
                <td style="padding: 8px;">Nurse</td>
                <td style="padding: 8px;"><code>nurse</code></td>
                <td style="padding: 8px;"><code>nurse123</code></td>
            </tr>
            <tr style="border-bottom: 1px solid #bfdbfe;">
                <td style="padding: 8px;">Pharmacist</td>
                <td style="padding: 8px;"><code>pharmacist1</code></td>
                <td style="padding: 8px;"><code>pharm123</code></td>
            </tr>
            <tr style="border-bottom: 1px solid #bfdbfe;">
                <td style="padding: 8px;">Lab Scientist</td>
                <td style="padding: 8px;"><code>lab_scientist</code></td>
                <td style="padding: 8px;"><code>lab123</code></td>
            </tr>
            <tr style="border-bottom: 1px solid #bfdbfe;">
                <td style="padding: 8px;">Accountant</td>
                <td style="padding: 8px;"><code>accountant</code></td>
                <td style="padding: 8px;"><code>account123</code></td>
            </tr>
            <tr style="border-bottom: 1px solid #bfdbfe;">
                <td style="padding: 8px;">Cook</td>
                <td style="padding: 8px;"><code>cook</code></td>
                <td style="padding: 8px;"><code>cook123</code></td>
            </tr>
            <tr>
                <td style="padding: 8px;" colspan="3">
                    <small><a href="DEMO_CREDENTIALS.md" target="_blank" style="color: #3b82f6;">See DEMO_CREDENTIALS.md for all 14 staff accounts</a></small>
                </td>
            </tr>
        </table>
    </div>

    <div style="margin-top: 1.5rem; text-align: center; padding-top: 1rem; border-top: 1px solid var(--border-color);">
        <p style="color: var(--text-light); margin-bottom: 0.5rem;">Wrong login type?</p>
        <a href="?action=home" style="color: #3b82f6; text-decoration: none;">Back to Login Selection</a>
    </div>
    <?php endif; ?>
</div>
