<?php
$db = Database::getInstance()->getConnection();

// Get statistics
$stats = [
    'total_hospitals' => $db->query("SELECT COUNT(*) FROM tenants")->fetchColumn(),
    'active_hospitals' => $db->query("SELECT COUNT(*) FROM tenants WHERE status = 'active'")->fetchColumn(),
    'pending_hospitals' => $db->query("SELECT COUNT(*) FROM tenants WHERE status = 'pending'")->fetchColumn(),
    'total_users' => $db->query("SELECT COUNT(*) FROM users WHERE role != 'super_admin'")->fetchColumn(),
    'total_patients' => $db->query("SELECT COUNT(*) FROM patients")->fetchColumn(),
];

// Get recent hospital registrations
$recentHospitals = $db->query("
    SELECT * FROM tenants
    ORDER BY created_at DESC
    LIMIT 10
")->fetchAll(PDO::FETCH_ASSOC);

// Get hospitals by status
$hospitalsByStatus = $db->query("
    SELECT status, COUNT(*) as count
    FROM tenants
    GROUP BY status
")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="hero">
    <h1>Super Admin Dashboard</h1>
    <p>Welcome back, <?= e($_SESSION['full_name']) ?></p>
    <p style="font-size: 0.95rem; opacity: 0.9;">Manage all hospitals and system-wide settings</p>
</div>

<!-- Statistics -->
<div class="stats">
    <div class="stat-card">
        <div class="stat-value"><?= $stats['total_hospitals'] ?></div>
        <div class="stat-label">Total Hospitals</div>
    </div>

    <div class="stat-card success">
        <div class="stat-value"><?= $stats['active_hospitals'] ?></div>
        <div class="stat-label">Active Hospitals</div>
    </div>

    <div class="stat-card warning">
        <div class="stat-value"><?= $stats['pending_hospitals'] ?></div>
        <div class="stat-label">Pending Approvals</div>
    </div>

    <div class="stat-card">
        <div class="stat-value"><?= $stats['total_users'] ?></div>
        <div class="stat-label">Total Users</div>
    </div>

    <div class="stat-card">
        <div class="stat-value"><?= $stats['total_patients'] ?></div>
        <div class="stat-label">Total Patients</div>
    </div>
</div>

<!-- Quick Actions -->
<div class="card">
    <h2>Quick Actions</h2>
    <div class="grid">
        <a href="?action=super_admin_hospitals" class="feature-card">
            <div class="feature-icon">H</div>
            <h3>Manage Hospitals</h3>
            <p>View, approve, and manage all hospitals</p>
        </a>

        <a href="?action=super_admin_hospitals&sub=pending" class="feature-card">
            <div class="feature-icon" style="background: linear-gradient(135deg, var(--warning-color), #f97316);">!</div>
            <h3>Pending Registrations</h3>
            <p><?= $stats['pending_hospitals'] ?> hospitals awaiting approval</p>
        </a>

        <a href="?action=super_admin_users" class="feature-card">
            <div class="feature-icon">U</div>
            <h3>All Users</h3>
            <p>View all users across all hospitals</p>
        </a>

        <a href="?action=super_admin_reports" class="feature-card">
            <div class="feature-icon">R</div>
            <h3>System Reports</h3>
            <p>Generate system-wide reports and analytics</p>
        </a>
    </div>
</div>

<!-- Recent Hospital Registrations -->
<div class="card">
    <h2>Recent Hospital Registrations</h2>
    <?php if (count($recentHospitals) > 0): ?>
        <div style="overflow-x: auto;">
            <table class="table">
                <thead>
                    <tr>
                        <th>Hospital Name</th>
                        <th>Subdomain</th>
                        <th>License Number</th>
                        <th>Contact</th>
                        <th>Registration Date</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($recentHospitals as $hospital): ?>
                        <tr>
                            <td><strong><?= e($hospital['name']) ?></strong></td>
                            <td><?= e($hospital['subdomain']) ?></td>
                            <td><?= e($hospital['license_number'] ?? 'N/A') ?></td>
                            <td>
                                <div><?= e($hospital['phone']) ?></div>
                                <small style="color: var(--text-light);"><?= e($hospital['email']) ?></small>
                            </td>
                            <td><?= e(date('M j, Y', strtotime($hospital['created_at']))) ?></td>
                            <td>
                                <span style="padding: 0.25rem 0.75rem; border-radius: 4px; font-size: 0.875rem;
                                    background-color: <?= $hospital['status'] === 'active' ? '#d1fae5' : ($hospital['status'] === 'pending' ? '#fef3c7' : '#fee2e2') ?>;
                                    color: <?= $hospital['status'] === 'active' ? '#065f46' : ($hospital['status'] === 'pending' ? '#92400e' : '#991b1b') ?>;">
                                    <?= e(ucfirst($hospital['status'])) ?>
                                </span>
                            </td>
                            <td>
                                <a href="?action=super_admin_hospitals&sub=view&id=<?= $hospital['id'] ?>" class="btn btn-secondary" style="padding: 0.5rem 1rem; font-size: 0.875rem;">View</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <p style="text-align: center; padding: 2rem; color: var(--text-light);">No hospitals registered yet</p>
    <?php endif; ?>
</div>

<!-- Hospital Status Overview -->
<div class="card">
    <h2>Hospital Status Overview</h2>
    <div class="grid">
        <?php foreach ($hospitalsByStatus as $status): ?>
            <div class="stat-card <?= $status['status'] === 'active' ? 'success' : ($status['status'] === 'pending' ? 'warning' : 'danger') ?>">
                <div class="stat-value"><?= $status['count'] ?></div>
                <div class="stat-label"><?= e(ucfirst($status['status'])) ?> Hospitals</div>
            </div>
        <?php endforeach; ?>
    </div>
</div>
