<?php
$db = Database::getInstance()->getConnection();
$subAction = $_GET['sub'] ?? 'list';

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['approve_hospital'])) {
        $hospitalId = $_POST['hospital_id'];

        $db->beginTransaction();
        try {
            // Approve hospital
            $stmt = $db->prepare("UPDATE tenants SET status = 'active' WHERE id = ?");
            $stmt->execute([$hospitalId]);

            // Get hospital details
            $stmt = $db->prepare("SELECT * FROM tenants WHERE id = ?");
            $stmt->execute([$hospitalId]);
            $hospital = $stmt->fetch(PDO::FETCH_ASSOC);

            // Create hospital admin user
            $username = strtolower($hospital['subdomain']) . '_admin';
            $password = bin2hex(random_bytes(8)); // Generate random password
            $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

            $stmt = $db->prepare("
                INSERT INTO users (tenant_id, username, password, full_name, email, role, employee_number)
                VALUES (?, ?, ?, ?, ?, 'hospital_admin', 'ADMIN001')
            ");
            $stmt->execute([
                $hospitalId,
                $username,
                $hashedPassword,
                'Hospital Administrator',
                $hospital['email']
            ]);

            $db->commit();

            $message = "Hospital approved successfully! Admin Username: {$username}, Password: {$password} (Please note this down)";
        } catch (Exception $e) {
            $db->rollBack();
            $error = 'Failed to approve hospital: ' . $e->getMessage();
        }
    } elseif (isset($_POST['reject_hospital'])) {
        $stmt = $db->prepare("UPDATE tenants SET status = 'rejected' WHERE id = ?");
        $stmt->execute([$_POST['hospital_id']]);
        $message = 'Hospital registration rejected.';
    } elseif (isset($_POST['suspend_hospital'])) {
        $stmt = $db->prepare("UPDATE tenants SET status = 'suspended' WHERE id = ?");
        $stmt->execute([$_POST['hospital_id']]);
        $message = 'Hospital suspended.';
    } elseif (isset($_POST['activate_hospital'])) {
        $stmt = $db->prepare("UPDATE tenants SET status = 'active' WHERE id = ?");
        $stmt->execute([$_POST['hospital_id']]);
        $message = 'Hospital activated.';
    }
}

// Get hospital for viewing
$viewHospital = null;
if ($subAction === 'view' && isset($_GET['id'])) {
    $stmt = $db->prepare("SELECT * FROM tenants WHERE id = ?");
    $stmt->execute([$_GET['id']]);
    $viewHospital = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($viewHospital) {
        // Get hospital statistics
        $hospitalId = $viewHospital['id'];
        $viewHospital['stats'] = [
            'users' => $db->query("SELECT COUNT(*) FROM users WHERE tenant_id = $hospitalId")->fetchColumn(),
            'patients' => $db->query("SELECT COUNT(*) FROM patients WHERE tenant_id = $hospitalId")->fetchColumn(),
            'doctors' => $db->query("SELECT COUNT(*) FROM doctors WHERE tenant_id = $hospitalId")->fetchColumn(),
            'appointments' => $db->query("SELECT COUNT(*) FROM appointments WHERE tenant_id = $hospitalId")->fetchColumn(),
        ];

        // Get hospital users
        $viewHospital['users'] = $db->query("SELECT * FROM users WHERE tenant_id = $hospitalId ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
    }
}

// Get hospitals based on filter
$filter = $subAction === 'pending' ? 'pending' : null;
if ($filter) {
    $hospitals = $db->query("SELECT * FROM tenants WHERE status = '$filter' ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
} else {
    $hospitals = $db->query("SELECT * FROM tenants ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
}
?>

<div class="hero">
    <h1>Hospital Management</h1>
    <p>View and manage all registered hospitals</p>
</div>

<?php if (isset($message)): ?>
    <div class="alert alert-success"><?= e($message) ?></div>
<?php endif; ?>

<?php if (isset($error)): ?>
    <div class="alert alert-error"><?= e($error) ?></div>
<?php endif; ?>

<?php if ($subAction === 'view' && $viewHospital): ?>
    <!-- Hospital Details View -->
    <div class="card">
        <div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 1.5rem; flex-wrap: wrap; gap: 1rem;">
            <div>
                <h2><?= e($viewHospital['name']) ?></h2>
                <p style="color: var(--text-light);">Subdomain: <?= e($viewHospital['subdomain']) ?></p>
            </div>
            <span style="padding: 0.5rem 1rem; border-radius: 6px; font-size: 0.875rem; font-weight: 600;
                background-color: <?= $viewHospital['status'] === 'active' ? '#d1fae5' : ($viewHospital['status'] === 'pending' ? '#fef3c7' : '#fee2e2') ?>;
                color: <?= $viewHospital['status'] === 'active' ? '#065f46' : ($viewHospital['status'] === 'pending' ? '#92400e' : '#991b1b') ?>;">
                <?= e(ucfirst($viewHospital['status'])) ?>
            </span>
        </div>

        <div class="grid">
            <div>
                <h3>Contact Information</h3>
                <div style="line-height: 2;">
                    <p><strong>Email:</strong> <?= e($viewHospital['email']) ?></p>
                    <p><strong>Phone:</strong> <?= e($viewHospital['phone']) ?></p>
                    <p><strong>Address:</strong> <?= e($viewHospital['address']) ?></p>
                    <?php if ($viewHospital['license_number']): ?>
                        <p><strong>License:</strong> <?= e($viewHospital['license_number']) ?></p>
                    <?php endif; ?>
                </div>
            </div>

            <div>
                <h3>Registration Details</h3>
                <div style="line-height: 2;">
                    <p><strong>Registered:</strong> <?= e(date('F j, Y', strtotime($viewHospital['created_at']))) ?></p>
                    <p><strong>Subdomain:</strong> <?= e($viewHospital['subdomain']) ?></p>
                </div>
            </div>
        </div>

        <!-- Statistics -->
        <h3 style="margin-top: 2rem; margin-bottom: 1rem;">Statistics</h3>
        <div class="stats">
            <div class="stat-card">
                <div class="stat-value"><?= $viewHospital['stats']['users'] ?></div>
                <div class="stat-label">Users</div>
            </div>
            <div class="stat-card">
                <div class="stat-value"><?= $viewHospital['stats']['patients'] ?></div>
                <div class="stat-label">Patients</div>
            </div>
            <div class="stat-card">
                <div class="stat-value"><?= $viewHospital['stats']['doctors'] ?></div>
                <div class="stat-label">Doctors</div>
            </div>
            <div class="stat-card">
                <div class="stat-value"><?= $viewHospital['stats']['appointments'] ?></div>
                <div class="stat-label">Appointments</div>
            </div>
        </div>

        <!-- Users List -->
        <h3 style="margin-top: 2rem; margin-bottom: 1rem;">Hospital Users</h3>
        <?php if (count($viewHospital['users']) > 0): ?>
            <div style="overflow-x: auto;">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Username</th>
                            <th>Full Name</th>
                            <th>Role</th>
                            <th>Email</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($viewHospital['users'] as $user): ?>
                            <tr>
                                <td><?= e($user['username']) ?></td>
                                <td><?= e($user['full_name']) ?></td>
                                <td><?= e(getRoleName($user['role'])) ?></td>
                                <td><?= e($user['email'] ?? 'N/A') ?></td>
                                <td>
                                    <span style="padding: 0.25rem 0.75rem; border-radius: 4px; font-size: 0.875rem;
                                        background-color: <?= $user['status'] === 'active' ? '#d1fae5' : '#fee2e2' ?>;
                                        color: <?= $user['status'] === 'active' ? '#065f46' : '#991b1b' ?>;">
                                        <?= e(ucfirst($user['status'])) ?>
                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p style="text-align: center; padding: 2rem; color: var(--text-light);">No users created yet</p>
        <?php endif; ?>

        <!-- Actions -->
        <div style="margin-top: 2rem; display: flex; gap: 1rem; flex-wrap: wrap;">
            <a href="?action=super_admin_hospitals" class="btn btn-secondary">Back to List</a>

            <?php if ($viewHospital['status'] === 'pending'): ?>
                <form method="POST" action="?action=super_admin_hospitals&sub=view&id=<?= $viewHospital['id'] ?>" style="display: inline;">
                    <input type="hidden" name="hospital_id" value="<?= $viewHospital['id'] ?>">
                    <button type="submit" name="approve_hospital" class="btn btn-success"
                            onclick="return confirm('Are you sure you want to approve this hospital?')">
                        Approve Hospital
                    </button>
                </form>
                <form method="POST" action="?action=super_admin_hospitals&sub=view&id=<?= $viewHospital['id'] ?>" style="display: inline;">
                    <input type="hidden" name="hospital_id" value="<?= $viewHospital['id'] ?>">
                    <button type="submit" name="reject_hospital" class="btn btn-danger"
                            onclick="return confirm('Are you sure you want to reject this hospital?')">
                        Reject
                    </button>
                </form>
            <?php elseif ($viewHospital['status'] === 'active'): ?>
                <form method="POST" action="?action=super_admin_hospitals&sub=view&id=<?= $viewHospital['id'] ?>" style="display: inline;">
                    <input type="hidden" name="hospital_id" value="<?= $viewHospital['id'] ?>">
                    <button type="submit" name="suspend_hospital" class="btn btn-danger"
                            onclick="return confirm('Are you sure you want to suspend this hospital?')">
                        Suspend Hospital
                    </button>
                </form>
            <?php elseif ($viewHospital['status'] === 'suspended'): ?>
                <form method="POST" action="?action=super_admin_hospitals&sub=view&id=<?= $viewHospital['id'] ?>" style="display: inline;">
                    <input type="hidden" name="hospital_id" value="<?= $viewHospital['id'] ?>">
                    <button type="submit" name="activate_hospital" class="btn btn-success"
                            onclick="return confirm('Are you sure you want to activate this hospital?')">
                        Activate Hospital
                    </button>
                </form>
            <?php endif; ?>
        </div>
    </div>
<?php else: ?>
    <!-- Hospital List -->
    <div class="card">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem; flex-wrap: wrap; gap: 1rem;">
            <h2><?= $subAction === 'pending' ? 'Pending' : 'All' ?> Hospitals (<?= count($hospitals) ?>)</h2>
            <div style="display: flex; gap: 0.5rem;">
                <a href="?action=super_admin_hospitals" class="btn <?= $subAction !== 'pending' ? 'btn-primary' : 'btn-secondary' ?>">All Hospitals</a>
                <a href="?action=super_admin_hospitals&sub=pending" class="btn <?= $subAction === 'pending' ? 'btn-primary' : 'btn-secondary' ?>">Pending Approvals</a>
            </div>
        </div>

        <?php if (count($hospitals) > 0): ?>
            <div style="overflow-x: auto;">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Hospital Name</th>
                            <th>Subdomain</th>
                            <th>License</th>
                            <th>Contact</th>
                            <th>Registered</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($hospitals as $hospital): ?>
                            <tr>
                                <td><strong><?= e($hospital['name']) ?></strong></td>
                                <td><?= e($hospital['subdomain']) ?></td>
                                <td><?= e($hospital['license_number'] ?? 'N/A') ?></td>
                                <td>
                                    <div><?= e($hospital['phone']) ?></div>
                                    <small style="color: var(--text-light);"><?= e($hospital['email']) ?></small>
                                </td>
                                <td><?= e(date('M j, Y', strtotime($hospital['created_at']))) ?></td>
                                <td>
                                    <span style="padding: 0.25rem 0.75rem; border-radius: 4px; font-size: 0.875rem;
                                        background-color: <?= $hospital['status'] === 'active' ? '#d1fae5' : ($hospital['status'] === 'pending' ? '#fef3c7' : '#fee2e2') ?>;
                                        color: <?= $hospital['status'] === 'active' ? '#065f46' : ($hospital['status'] === 'pending' ? '#92400e' : '#991b1b') ?>;">
                                        <?= e(ucfirst($hospital['status'])) ?>
                                    </span>
                                </td>
                                <td>
                                    <a href="?action=super_admin_hospitals&sub=view&id=<?= $hospital['id'] ?>" class="btn btn-secondary" style="padding: 0.5rem 1rem; font-size: 0.875rem;">View Details</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p style="text-align: center; padding: 3rem; color: var(--text-light);">
                No <?= $subAction === 'pending' ? 'pending' : '' ?> hospitals found.
            </p>
        <?php endif; ?>
    </div>
<?php endif; ?>
