<?php
$db = Database::getInstance()->getConnection();

// System-wide statistics
$systemStats = [
    'total_hospitals' => $db->query("SELECT COUNT(*) FROM tenants")->fetchColumn(),
    'active_hospitals' => $db->query("SELECT COUNT(*) FROM tenants WHERE status = 'active'")->fetchColumn(),
    'total_users' => $db->query("SELECT COUNT(*) FROM users WHERE role != 'super_admin'")->fetchColumn(),
    'total_patients' => $db->query("SELECT COUNT(*) FROM patients")->fetchColumn(),
    'total_doctors' => $db->query("SELECT COUNT(*) FROM doctors")->fetchColumn(),
    'total_appointments' => $db->query("SELECT COUNT(*) FROM appointments")->fetchColumn(),
    'total_admissions' => $db->query("SELECT COUNT(*) FROM admissions")->fetchColumn(),
    'total_revenue' => $db->query("SELECT SUM(amount) FROM billing WHERE payment_status = 'paid'")->fetchColumn() ?? 0,
];

// Top hospitals by patients
$topHospitals = $db->query("
    SELECT t.name, t.subdomain, COUNT(p.id) as patient_count
    FROM tenants t
    LEFT JOIN patients p ON t.id = p.tenant_id
    WHERE t.status = 'active'
    GROUP BY t.id
    ORDER BY patient_count DESC
    LIMIT 10
")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="hero">
    <h1>System Reports & Analytics</h1>
    <p>Comprehensive system-wide reports and statistics</p>
</div>

<div class="card">
    <h2>System-Wide Statistics</h2>
    <div class="stats">
        <div class="stat-card">
            <div class="stat-value"><?= $systemStats['total_hospitals'] ?></div>
            <div class="stat-label">Total Hospitals</div>
        </div>
        <div class="stat-card success">
            <div class="stat-value"><?= $systemStats['active_hospitals'] ?></div>
            <div class="stat-label">Active Hospitals</div>
        </div>
        <div class="stat-card">
            <div class="stat-value"><?= $systemStats['total_users'] ?></div>
            <div class="stat-label">Total Users</div>
        </div>
        <div class="stat-card">
            <div class="stat-value"><?= $systemStats['total_patients'] ?></div>
            <div class="stat-label">Total Patients</div>
        </div>
        <div class="stat-card">
            <div class="stat-value"><?= $systemStats['total_doctors'] ?></div>
            <div class="stat-label">Total Doctors</div>
        </div>
        <div class="stat-card">
            <div class="stat-value"><?= $systemStats['total_appointments'] ?></div>
            <div class="stat-label">Total Appointments</div>
        </div>
        <div class="stat-card">
            <div class="stat-value"><?= $systemStats['total_admissions'] ?></div>
            <div class="stat-label">Total Admissions</div>
        </div>
        <div class="stat-card success">
            <div class="stat-value"><?= formatCurrency($systemStats['total_revenue']) ?></div>
            <div class="stat-label">Total Revenue</div>
        </div>
    </div>
</div>

<div class="card">
    <h2>Top Hospitals by Patient Count</h2>
    <div style="overflow-x: auto;">
        <table class="table">
            <thead>
                <tr>
                    <th>Rank</th>
                    <th>Hospital Name</th>
                    <th>Subdomain</th>
                    <th>Total Patients</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($topHospitals as $index => $hospital): ?>
                    <tr>
                        <td><strong>#<?= $index + 1 ?></strong></td>
                        <td><?= e($hospital['name']) ?></td>
                        <td><?= e($hospital['subdomain']) ?></td>
                        <td><strong><?= $hospital['patient_count'] ?></strong></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
