<?php
$db = Database::getInstance()->getConnection();

// Get all users across all hospitals
$users = $db->query("
    SELECT u.*, t.name as hospital_name, t.subdomain
    FROM users u
    LEFT JOIN tenants t ON u.tenant_id = t.id
    WHERE u.role != 'super_admin'
    ORDER BY t.name, u.full_name
")->fetchAll(PDO::FETCH_ASSOC);

// Get statistics
$stats = [
    'total_users' => count($users),
    'hospital_admins' => $db->query("SELECT COUNT(*) FROM users WHERE role = 'hospital_admin'")->fetchColumn(),
    'doctors' => $db->query("SELECT COUNT(*) FROM users WHERE role = 'doctor'")->fetchColumn(),
    'nurses' => $db->query("SELECT COUNT(*) FROM users WHERE role = 'nurse'")->fetchColumn(),
];
?>

<div class="hero">
    <h1>All System Users</h1>
    <p>View all users across all hospitals</p>
</div>

<div class="stats">
    <div class="stat-card">
        <div class="stat-value"><?= $stats['total_users'] ?></div>
        <div class="stat-label">Total Users</div>
    </div>
    <div class="stat-card">
        <div class="stat-value"><?= $stats['hospital_admins'] ?></div>
        <div class="stat-label">Hospital Admins</div>
    </div>
    <div class="stat-card">
        <div class="stat-value"><?= $stats['doctors'] ?></div>
        <div class="stat-label">Doctors</div>
    </div>
    <div class="stat-card">
        <div class="stat-value"><?= $stats['nurses'] ?></div>
        <div class="stat-label">Nurses</div>
    </div>
</div>

<div class="card">
    <h2>All Users</h2>
    <div style="overflow-x: auto;">
        <table class="table">
            <thead>
                <tr>
                    <th>Hospital</th>
                    <th>Username</th>
                    <th>Full Name</th>
                    <th>Role</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Status</th>
                    <th>Created</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($users as $user): ?>
                    <tr>
                        <td><?= e($user['hospital_name'] ?? 'N/A') ?></td>
                        <td><?= e($user['username']) ?></td>
                        <td><?= e($user['full_name']) ?></td>
                        <td><?= e(getRoleName($user['role'])) ?></td>
                        <td><?= e($user['email'] ?? 'N/A') ?></td>
                        <td><?= e($user['phone'] ?? 'N/A') ?></td>
                        <td>
                            <span style="padding: 0.25rem 0.75rem; border-radius: 4px; font-size: 0.875rem;
                                background-color: <?= $user['status'] === 'active' ? '#d1fae5' : '#fee2e2' ?>;
                                color: <?= $user['status'] === 'active' ? '#065f46' : '#991b1b' ?>;">
                                <?= e(ucfirst($user['status'])) ?>
                            </span>
                        </td>
                        <td><?= e(date('M j, Y', strtotime($user['created_at']))) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
